import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import '../../../common/widgets/text.dart';

class EmptyView extends StatelessWidget {
  final double? width;
  final double? height;
  final String? path;
  final String? message;
  final bool? haveImage;
  const EmptyView(
      {super.key, this.height, this.width, this.path, this.message , this.haveImage = true});

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        haveImage!? Image.asset(
          path ?? "asset/images/No-Data.png",
          width: width ?? 100,
          height: width ?? 100,
        ) : const SizedBox(),
        RegularText(message ?? "No Data Available", size: 12,)
      ],
    );
  }
}
