import 'package:flutter/material.dart';
import '../../../common/constant/colors.dart';
import '../../../common/constant/font.dart';
import '../../../common/extensions/widget.dart';
import '../../../common/widgets/text.dart';

class ErrorView extends StatelessWidget {
  final VoidCallback onRetry;
  const ErrorView({super.key, required this.onRetry});

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: onRetry,
      child: HeadTitleText(
        'Try Again',
        size: 20,
        color: AppColors.newPrimeColor,
        fontFamily: AppFonts.alatsi,
      ).center(),//const Text('Try Again').center(),
    );
  }
}
