import 'dart:math' as math;

import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:get/get.dart';
import '../../../core/lang/app_language_controller.dart';
import '../../../main.dart';

import '../../core/routing/routing_manager.dart';
import '../constant/colors.dart';
import '../extensions/widget.dart';
import 'text.dart';

class AppBarWidget extends StatelessWidget implements PreferredSizeWidget {
  final String locale = Get.deviceLocale.toString();
final  AppLanguageController appLanguageController =
      Get.put(AppLanguageController());
  // String? language;
  // Future<void> getLang() async {
  //  String? language = await sharepref!.getString("lang");
  //   print("EEEEEEEEe");
  //   print(language);
  // }

  final String title;
 final Widget? child;
  AppBarWidget({super.key, required this.title , this.child});
  @override
  Size get preferredSize => const Size.fromHeight(70);

  @override
  Widget build(BuildContext context) {
    String? language = sharepref!.getString("lang");

    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)
      ),
      // color: AppColors.newPrimeColor,
      child: Padding(
        padding: const EdgeInsets.only(top: 30),
        child:
            Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
          language == 'ar'
              ? Transform.rotate(
                  angle: 180 * math.pi / 180,
                  child: IconButton(
                      onPressed: () {
                        RoutingManager.back();
                        //print(locale);
                      },
                    // icon: Icon(
                    //   Icons.arrow_back,
                    //   color: AppColors.newPrimeColor,
                    //   size: 30,
                    // ),
                      icon: SvgPicture.asset(
                        'asset/icons/Arrow - Left Square.svg',
                        color: AppColors.newPrimeColor,
                        // color: Colors.white,
                      )
                  ))
              : IconButton(
                  onPressed: () {
                    RoutingManager.back();
                    // print(locale);
                  },
                  // icon: Icon(
                  //   Icons.arrow_back,
                  //   color: AppColors.newPrimeColor,
                  //   size: 30,
                  // ),
                  icon: SvgPicture.asset(
                    'asset/icons/Arrow - Left Square.svg',
                    color: AppColors.newPrimeColor,
                    // color: Colors.white,
                  )
          ).paddingSymmetric(horizontal: 10),
          HeadTitleText(title).center().expanded(4),
          (child ?? Container()).expanded(1)
        ]),
      ),
    );
  }
}
