import 'package:fl_chart/fl_chart.dart';
import 'package:flutter/material.dart';

import '../../../common/widgets/text.dart';

import '../../features/exam/data/models/exam_model.dart';
import '../constant/colors.dart';

class PercentExamWidget extends StatelessWidget {
  ExamModel examModel;
  PercentExamWidget({super.key, required this.examModel});

  @override
  Widget build(BuildContext context) {
    double value = examModel.markModel.mark / examModel.maxMark * 100;
    if (value > 100) {
      value = 100;
    }
    if (value < 0) {
      value = 0;
    }

    return SizedBox(
      height: 80,
      width: 80,
      child: Stack(
        alignment: Alignment.center,
        children: [
          TextTitle(
            examModel.markModel.mark.toInt().toString(),  
            textColor: AppColors.primeColor,
          ),
          PieChart(PieChartData(centerSpaceRadius: 30, sections: [
            PieChartSectionData(
              showTitle: false,
              value: 100 - value,
              color: Colors.white,
              radius: 5,
            ),
            PieChartSectionData(
              value: value,
              color: AppColors.primeColor,
              radius: 5,
              titlePositionPercentageOffset: 0,
              showTitle: false,
            ),
          ])),
        ],
      ),
    );
  }
}
