import 'package:flutter/material.dart';
import 'package:get/get_utils/src/extensions/internacionalization.dart';

import '../constant/colors.dart';
import '../constant/font.dart';

class HeadTitleText extends StatelessWidget {
  final String title;
  final String? fontFamily;
  final Color? color;
  final double? size;
  const HeadTitleText(this.title,  {super.key, this.color,this.fontFamily , this.size});

  @override
  Widget build(BuildContext context) {
    return Text(
      title,
      style: TextStyle(
          color: color ,
          fontFamily: fontFamily ?? AppFonts.bold,
          fontSize: size ?? 18),
    );
  }
}

class TextTitle extends StatelessWidget {
  final String title;
  final Color? textColor;
  final double? size;
  const TextTitle(this.title, {super.key, this.textColor, this.size});

  @override
  Widget build(BuildContext context) {
    return Text(
      title.tr,
      style: TextStyle(
        color: textColor ?? Colors.white,
        fontFamily: AppFonts.bold,
        fontSize: size ?? 17,
      ),
    );
  }
}

class NormalText extends StatelessWidget {
  final String title;
  final Color? textColor;
  final double? size;
  final String? fontFamily;
  const NormalText(this.title, {super.key, this.textColor, this.size, this.fontFamily});

  @override
  Widget build(BuildContext context) {
    return Text(
      title,
      style: TextStyle(
        color: textColor ?? Colors.white,
        fontFamily: fontFamily ?? AppFonts.regular,
        fontSize: size ?? 14,
      ),
    );
  }
}

class RegularText extends StatelessWidget {
  final String title;
  final Color? textColor;
  final double? size;
  const RegularText(this.title, {super.key, this.textColor , this.size});

  @override
  Widget build(BuildContext context) {
    return Text(
      title.tr,
      style: TextStyle(
        color: textColor ?? AppColors.secondaryColor,
        fontFamily: AppFonts.regular,
        fontSize:size?? 18,
      ),
    );
  }
}
