import 'dart:convert';

import '../../../features/auth/business_logic/auth_controller.dart';
import '../../../features/home/common/constant.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:http/http.dart' as http;

class Api {

  // final String _url = 'http://192.168.1.10:8080/';// with local
  // final String _url = 'https://incentive-dev.com/';// with demo
  var _token;

  var token = AuthController().token;

  _getToken() async {
    SharedPreferences localStorage = await SharedPreferences.getInstance();
    // _token = localStorage.getString('token');
    _token = token;
  }


  getTeacherData(apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.get(
        Uri.parse(fullUrl),
        headers: _setHeaders()
    );
  }

  getData(apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.get(
        Uri.parse(fullUrl),
        headers: _setHeaders()
    );
  }

  authData(data, apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    return await http.post(
        Uri.parse(fullUrl),
        body: jsonEncode(data),
        headers: _setHeaders()
    );
  }

  _setHeadersAuth() => {
    'Content-type': 'application/json',
    'Accept': 'application/json',
  };

  postData(data, apiUrl) async{
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.post(
        Uri.parse(fullUrl),
        body: jsonEncode(data),
        headers: _setHeaders()
    );
  }

  _setHeaders() => {
    'Content-type': 'application/json',
    'Accept': 'application/json',
    'Authorization': 'Bearer $token'
  };
}