import 'package:dio/dio.dart';

class DioInstance {
  Dio? _dio;

  Dio get dio => _dio ?? _instantiate();

  Dio _instantiate() {
    Dio dio = Dio(
      BaseOptions(
        // baseUrl: "https://demo-back.incentive-dev.com/api/",
        // baseUrl: "https://back-demo.incentive-dev.com/api/",
        // baseUrl: "https://friendship-back.incentive-dev.com/api/",
        baseUrl: "https://lbbis-back.incentive-dev.com/api/",
        receiveDataWhenStatusError: true,
      ),
    );

    dio.interceptors.add(
      LogInterceptor(
        request: true,
        responseHeader: false,
        requestHeader: false,
        requestBody: true,
        responseBody: true,
      ),
    );

    return dio;
  }
}