import 'dart:convert';
import 'dart:developer';

import 'package:dio/dio.dart';
import 'package:get/get.dart' as stateGet;
import '../../../features/auth/business_logic/auth_controller.dart';

import '../network/dio.dart';

import "../errors/custom_exception.dart";
import '../../utils/utils.dart';

enum RequestMethod { get, post, delete, put, patch }

class Request {
  String endPoint;
  bool authorized;
  bool isFormData;
  bool removeMockMatch;
  RequestMethod method;
  Map<String, dynamic>? headers;
  Map<String, dynamic>? body;
  var formData;
  Map<String, dynamic>? queryParams;

  Request(
    this.endPoint,
    this.method, {
    this.authorized = false,
    this.removeMockMatch = false,
    this.queryParams,
    this.isFormData =
        false, // TODO: formData should be handled in different way.
    this.headers,
    this.body,
    this.formData,
  }) {
    if (authorized) {
      AuthController authController = stateGet.Get.find<AuthController>();
      log('sended token : ${authController.token}');
      if (formData!=null) {
        headers = {
          "Authorization": "Bearer " '${authController.token}',
          "Accept": "application/json",
          'content-Type' :  "application/form-data"
        };
      }
      else {
        headers = {
          "Authorization": "Bearer " '${authController.token}',
          "Accept": "application/json",
        };
      }
      
    }

    if (isFormData) {
      log('im form data');
      FormData f = FormData.fromMap(body!);
      for (var pair in f.fields) {
        log('${pair.key}/${pair.value}');
      }
    }
    if (formData!=null) {
      log('im form data');
    }
  }

  Future<Map<String, dynamic>> sendRequest() async {
    Response? response;
    try {
      print(body);
      response = await DioInstance().dio.request(
            endPoint,
            data: (formData) ?? (isFormData ? FormData.fromMap(body!) : body),
            options: Options(
              method: Utils.requestTypeToString(method),
              headers: headers,
              // contentType: 'application/json',
            ),
            queryParameters: queryParams,
          );

      if (response.statusCode! >= 200 && response.statusCode! < 300) {
        //TODO: this should be handled in different way.
        if (response.data is String) return json.decode(response.data);
        return response.data;
      }
    } on DioError catch (error) {
      // handling http status code exceptions
      if (error.type == DioErrorType.badResponse) {
        // handling bad requests.
        if (error.response!.statusCode == 400) {
          // this line is really depends on what server responds, and how it reply with errors.
          throw badRequestException[error.response!.data["error"]] ??
              GenericException(
                type: ExceptionType.Other,
              );
        }

        // handling other status codes.
        throw statusCodesException[error.response!.statusCode] ??
            GenericException(
              type: ExceptionType.Other,
            );
      }

      // handling connection problems.
      if (error.type == DioErrorType.connectionTimeout ||
          error.type == DioErrorType.sendTimeout ||
          error.type == DioErrorType.receiveTimeout ||
          error.type == DioErrorType.unknown) {
        throw GenericException(
          type: ExceptionType.ConnectionError,
          errorMessage: "You Have no Internet Connection",
        );
      }

      
      // handling unknown errors.
      throw GenericException(
        type: ExceptionType.Other,
        errorMessage: "Unknown Error",
      );
    }
    return {};
  }
}
