import 'package:get/get.dart';
import '../../../features/chat/presentation/screens/new_mail.dart';
import '../../../features/class/presentation/screens/homework_details.dart';
import '../../../features/class/presentation/screens/class_screen.dart';
import '../../../features/home/presentation/screens/pages/mainExamPage.dart';
import '../../../features/homework/presentation/screens/homework_page.dart';
import '../../../features/lms/presentation/screens/lmsIndex_page.dart';
import '../../../features/lms/presentation/screens/lmsQuiz.dart';
import '../../../features/lms/presentation/screens/lmsSummary.dart';
import '../../../features/lms/presentation/screens/startQuiz.dart';
import '../../../features/new_purchase/screen/new_weeklyPurchase.dart';
import '../../../features/variable/presentation/screens/homeVariable.dart';
import '../../../features/weekly_class/presentation/screens/weekly_class_screen.dart';
import '../../features/auth/presentation/screens/login.dart';
import '../../features/auth/presentation/screens/verification_code.dart';
import '../../features/calender/presentation/screens/calender_page.dart';
import '../../features/chat/presentation/screens/mail.dart';
import '../../features/exam/presentation/screens/exam_page.dart';
import '../../features/exam/presentation/screens/result_page.dart';
import '../../features/home/presentation/screens/home_page.dart';
import '../../features/home/presentation/screens/pages/food.dart';
import '../../features/home/presentation/screens/pages/webViewAppScreen.dart';
import '../../features/lms/presentation/screens/lmsSplash.dart';
import '../../features/notes/presentation/screens/note_detail.dart';
import '../../features/notes/presentation/screens/note_page.dart';
import '../../features/notification/presentation/screens/notification_page.dart';
import '../../features/purchase/screens/purchase_screen.dart';
import '../../features/restaurant/presentation/screens/change.dart';
import '../../features/restaurant/presentation/screens/meals_menu.dart';
import '../../features/restaurant/presentation/screens/restaurant_screen.dart';
import '../../features/setting/presentation/screens/setting_page.dart';
import '../../features/chat/presentation/screens/chat_page.dart';
import '../../features/chat/presentation/screens/chat_teacher_page.dart';
import '../../features/wallet/presentation/widget/chargeScreen.dart';

class RoutesName {
  static String login = '/login';
  static String verificationCode = '/verification-code';
  static String homePage = '/home-page';
  static String calenderPage = '/calender-page';
  static String notificationPage = '/notification-page';
  static String notePage = '/note-page';
  static String noteDetail = '/note-detail';
  static String settingPage = '/setting-page';
  static String chatPage = "/chat-page";
  static String chatTeacherPage = '/chat-teacher-page';
  static String restaurantPage = '/restaurant-page';
  static String buffetPage = '/buffet-page';
  static String mealsMenuPage = '/meals-menu-page';
  static String changePage = '/change-page';
  static String website= '/website-page';
  static String chargeScreen= '/charge-page';
  static String newMessagePage = '/new-message-page';
  static String mailPage = '/mail-page';
  static String examPage = '/exam-page';
  static String resultPage = '/result-page';
  static String examDetails = '/exam-details-page';
  static String homeworkDetailsScreen = '/homework-details-page';
  static String weeklyClass = '/weekly-class';
  static String classPage = '/class-page';
  static String mainExamPage = '/mainExamPage';
  static String homeWorkPage = '/homeworkePage';
  static String lmsPage = '/lmsPage';
  static String lmsQuiz = '/lmsQuiz';
  static String lmsSplash = '/lmsSplash';
  static String startQuiz = '/quizStart';
  static String lmsSummary = '/lmsSummary';
  static String variable = '/variable';
  static String newWeeklyPurchase= '/newWeeklyPurchase';
  static String food = '/food';
}

class RoutingManager {
  static List<GetPage<dynamic>> pages = [
    GetPage(
      name: RoutesName.login,
      page: () => LogIn(),
    ),
    GetPage(
      name: RoutesName.verificationCode,
      page: () => VerificationCode(),
    ),
    GetPage(
      name: RoutesName.homeWorkPage,
      page: () => HomeworkPage(),
    ),
    GetPage(
      name: RoutesName.homePage,
      page: () => HomePageScreen(),
      // middlewares: [HomePageMiddlewara()]
    ),
    GetPage(
      name: RoutesName.calenderPage,
      page: () => CalenderPage(),
    ),
    GetPage(
      name: RoutesName.notificationPage,
      page: () => NotificationPage(),
    ),
    GetPage(
      name: RoutesName.notePage,
      page: () => NotesPage(),
    ),
    GetPage(
      name: RoutesName.noteDetail,
      page: () => NoteDetailsScreen(),
    ),
    GetPage(
      name: RoutesName.settingPage,
      page: () => SettingPage(),
    ),
    GetPage(
      name: RoutesName.chatTeacherPage,
      page: () => ChatTeacherPage(),
    ),
    GetPage(
      name: RoutesName.chatPage,
      page: () => ChatPage(),
    ),
    GetPage(
        name: RoutesName.website,
        page: ()=> WebViewApp()
    ),
    GetPage(
        name: RoutesName.chargeScreen,
        page: ()=> ChargeScreen()
    ),
    GetPage(
      name: RoutesName.mailPage,
      page: () => MailPage(),
    ),
    GetPage(
      name: RoutesName.newMessagePage,
      page: () => NewMail(),
    ),
    GetPage(
        name: RoutesName.restaurantPage,
        page: () => RestaurantScreen(),
        middlewares: [RestaurantScreenMiddleware()]),
    GetPage(
        name: RoutesName.buffetPage,
        page: () => const PurchaseScreen(),
        middlewares: [PurchaseScreenMiddleware()]
    ),
    GetPage(
      name: RoutesName.mealsMenuPage,
      page: () => MealsMenuPage(),
    ),
    GetPage(
      name: RoutesName.changePage,
      page: () => ChangePage(),
    ),
    GetPage(
      name: RoutesName.examPage,
      page: () => ExamPage(),
    ),
    GetPage(
      name: RoutesName.resultPage,
      page: () => ResultPage(),
    ),
    GetPage(
      name: RoutesName.homeworkDetailsScreen,
      page: () => HomeworkDetailsScreen(),
    ),
    GetPage(
      name: RoutesName.weeklyClass,
      page: () => WeeklyClassScreen(),
    ),
    GetPage(
      name: RoutesName.classPage,
      page: () => ClassScreen(),
    ),
    GetPage(
      name: RoutesName.mainExamPage,
      page: () => MainExamPage(),
    ),
    GetPage(
      name: RoutesName.lmsPage,
      page: () => LmsIndexPage(),
    ),
    GetPage(
      name: RoutesName.lmsQuiz,
      page: () => LmsQuiz(),
      transition: Transition.leftToRight
    ),
    GetPage(
      name: RoutesName.lmsSplash,
      page: () => LmsSplashQuiz(),
      transition: Transition.leftToRight
    ),
    GetPage(
      name: RoutesName.startQuiz,
      page: () => StartQuiz(),
      transition: Transition.leftToRight
    ),
    GetPage(
        name: RoutesName.lmsSummary,
        page: () => LmsSummary(),
        transition: Transition.leftToRight
    ),
    GetPage(
        name: RoutesName.variable,
        page: ()=> HomeVariable()
    ),
    GetPage(
        name: RoutesName.newWeeklyPurchase,
        page: () => NewWeeklyPurchase()
    ),
    GetPage(
      name: RoutesName.food,
      page: () => Food(),
    )
  ];

  static void off(String route) {
    Get.offNamed(route);
  }

  static void offAll(String route) {
    Get.offAllNamed(route);
  }

  static void to(String route, {dynamic arguments}) {
    Get.toNamed(route, arguments: arguments);
  }

  static void back() {
    Get.back();
  }
}
