import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/auth/data/models/login_request.dart';
import '../../../../features/auth/data/models/login_response.dart';

class LoginService {
  Future<LoginResponse> login(LoginRequest loginRequest) async {
    Request request = Request(
      EndPoints.login,
      RequestMethod.post,
      body: loginRequest.toJson(),
      headers: {
        "Accept": "application/json"
      }
    );
    Map<String, dynamic> response = await request.sendRequest();
    return LoginResponse.fromJson(response);
  }

  Future<void> sendFCMToken(String FCM) async{
    Request request = Request(
      EndPoints.sendFCMToken,
      RequestMethod.post,
      body: {
        "token": FCM
      }
    );
    Map<String, dynamic> response = await request.sendRequest();
  }
}
