import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/auth/presentation/widgets/button.dart';
import '../../../../common/widgets/text.dart';

import '../../../../common/widgets/text_field.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../features/auth/presentation/widgets/logo.dart';
import 'package:get/get.dart';

class LogIn extends StatelessWidget {
  LogIn({super.key});

  AuthController authController = Get.find<AuthController>();

  @override
  Widget build(BuildContext context) {
    return Container(

      child: Scaffold(
          resizeToAvoidBottomInset: false,
          backgroundColor:  const Color.fromRGBO(238, 238, 238, 1),
          body: SingleChildScrollView(
              child: Container(
                decoration: const BoxDecoration(
                    image: DecorationImage(
                      image: AssetImage('asset/images/backGroundLogIn1.png'),
                      fit: BoxFit.cover,
                    )),
                padding: EdgeInsets.only(top: Get.height * 0.06/*50*/),
                child: Column(
                  children: [
                    Stack(
                      alignment: Alignment.bottomCenter,
                      children: [
                        Container(
                            height: MediaQuery.of(context).size.height * 1.1,
                            width: double.infinity,
                            decoration: const BoxDecoration(
                                color: Color.fromRGBO(238, 238, 238, 1),//Colors.grey,
                                image: DecorationImage(
                                    image: AssetImage('asset/images/backGroundLogIn1.png'),
                                    fit: BoxFit.cover)),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                const Logo(),//.expanded(0),
                                Padding(
                                    padding: EdgeInsets.only(top: Get.height * 0.00/*45*/, right: Get.width * 0.09, left: Get.width * 0.09 ),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.start,
                                      children: [
                                        const Icon(CupertinoIcons.phone).padding(
                                            padding: const EdgeInsets.only(bottom: 6)),
                                        SizedBox(width: Get.width * 0.05/*45*/,),
                                        HeadTitleText(
                                          'Phone Number'.tr,
                                          color: AppColors.newPrimeColor,
                                        ).padding(
                                            padding: const EdgeInsets.only(bottom: 6)),
                                      ],
                                    )),
                                TextFieldWidget(
                                  onChange: (value) {
                                    authController.loginRequest.phoneNumber = value;
                                    if (authController.loginRequest.phoneNumber.isNotEmpty) {
                                      authController.onIgnoring();
                                    } else {
                                      authController.ignoring(false);
                                    }
                                  },
                                  keyboardType: TextInputType.phone,
                                ).center(),
                                Padding(
                                    padding: EdgeInsets.only(top: Get.height * 0.02/*45*/, right: Get.width * 0.09, left: Get.width * 0.09 ),
                                    child: Row(
                                      children: [
                                        const Icon(CupertinoIcons.lock_circle).padding(
                                            padding: const EdgeInsets.only(bottom: 6)),
                                        SizedBox(width: Get.width * 0.05/*45*/,),
                                        HeadTitleText(
                                          'password'.tr,
                                          color: AppColors.newPrimeColor,
                                        ).padding(
                                            padding: const EdgeInsets.only(bottom: 6)),
                                      ],
                                    )
                                ),
                                TextFieldWidget(
                                  onChange: (value) {
                                    authController.loginRequest.password = value;
                                    if (authController.loginRequest.password.isNotEmpty) {
                                      authController.onIgnoring();
                                    } else {
                                      authController.ignoring(false);
                                    }
                                  },
                                  keyboardType: TextInputType.text,
                                ).center()
                              ],
                            ).padding(padding: EdgeInsets.only(top: Get.height * 0.02/*20*/))
                        ),
                        Container(
                          height: Get.height * .34,//.18,
                          width: double.infinity,
                          decoration: BoxDecoration(
                              color: AppColors.newPrimeColor,
                              image: const DecorationImage(
                                  image: AssetImage('asset/images/backGroundLogIn.png'),
                                  fit: BoxFit.cover)),

                        ),
                        Positioned(
                          bottom: MediaQuery.of(context).size.height * .31,
                          child: Container(
                            decoration: BoxDecoration(
                                borderRadius: const BorderRadius.all(
                                  Radius.circular(40),
                                ),
                                border: Border.all(
                                    color: AppColors.newPrimeColor
                                )
                            ),
                            height: MediaQuery.of(context).size.height * 0.06,
                            width: MediaQuery.of(context).size.width * 0.8,
                            alignment: Alignment.center,
                            child:
                            Obx((){
                              return IgnorePointer(
                                ignoring: !authController.ignoring.value,
                                child: ButtonWidget(
                                  isLoading: authController.loginState.loading,
                                  backGroundColor: authController.ignoring.isFalse
                                      ? AppColors.newSecondaryColor
                                      : AppColors.newSecondaryColor, 
                                  title: 'Log in'.tr,
                                  onTap: () {
                                    print(authController.ignoring.value);
                                    authController.phoneNumberFilled
                                        ? authController.login()
                                        : Get.snackbar(
                                        duration: const Duration(
                                          milliseconds: 1000,
                                        ),
                                        'Empty fields',
                                        'please fill the fields');
                                  },
                                ).center(),
                              );
                            })
                            ,
                          )
                          ,
                        ),
                      ],
                    ),
                  ],
                ),
              )
          )),
    );
  }

  bool isArabic(){
    String currentLanguageCode = Get.locale.toString();
    if(currentLanguageCode == 'ar'){
      return true;
    }else{
      return false;
    }
  }

}
