import '../../../../features/calender/data/models/grade_type_model.dart';

class SubjectResponse {
  String id;
  String name;
  int quizNumber;

  GradeType gradeType;

  SubjectResponse({
    required this.id,
    required this.name,
    required this.quizNumber,
    required this.gradeType,
  });

  factory SubjectResponse.fromJson(Map<String, dynamic> json) =>
      SubjectResponse(
        id: json['id'].toString(),
        name: json['name'],
        quizNumber: json['quiz_number'] ?? 0,
        gradeType: GradeType.fromJson(json['grade_type']),
      );

  factory SubjectResponse.zero() => SubjectResponse(
        id: '',
        name: '',
        quizNumber: 0,
        gradeType: GradeType.zero(),
      );

  static List<SubjectResponse> fromJsonList(
    Map<String, dynamic> json,
    String key,
  ) {
    List<SubjectResponse> subjects = [];

    if (json[key] == null) {
      return [];
    }

    try {
      json[key].forEach(
        (subject) => subjects.add(
          SubjectResponse.fromJson(subject),
        ),
      );
    } catch (e) {
      print(e);
    }

    return subjects;
  }

  bool compare(SubjectResponse subjectResponse) {
    if (id == subjectResponse.id) {
      return true;
    } else if (name == subjectResponse.name) {
      return true;
    } else if (gradeType == subjectResponse.gradeType) {
      return true;
    } else {
      return false;
    }
  }
}
