import 'dart:io';

import 'package:dio/dio.dart';
import 'package:get/get.dart';
import 'package:permission_handler/permission_handler.dart';
import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/calender/data/models/homework_details_model.dart';

import '../../../auth/business_logic/auth_controller.dart';
import '../models/homework_model.dart';

class HomeWorkService {
  Future<List<HomeWorkModel>> getHomework(String registrationRecordId,
      {String? dueFrom, String? dueTo}) async {
    Request request = Request(
      queryParams:
          dueFrom != null ? {"due_from": dueFrom, "due_to": dueTo} : null,
      authorized: true,
      EndPoints.getHomework(registrationRecordId),
      RequestMethod.get,
    );
    Map<String, dynamic> response = await request.sendRequest();

    return HomeWorkModel.fromJsonList(response);
  }

  Future<List<HomeWorkModel>> lastHomework(String registrationRecordId,
      {String? createdFrom, String? createdTo}) async {
    Request request = Request(
      queryParams: createdFrom != null
          ? {
              "created_from": "$createdFrom 00:00:00",
              "created_to": "$createdTo 23:59:59"
            }
          : null,
      authorized: true,
      EndPoints.getHomework(registrationRecordId),
      RequestMethod.get,
    );
    Map<String, dynamic> response = await request.sendRequest();

    return HomeWorkModel.fromJsonList(response);
  }

  Future<List<HomeWorkModel>> homeworkDelivery(String registrationRecordId,
      {String? dueFrom}) async {
    Request request = Request(
      EndPoints.getHomework(registrationRecordId),
      RequestMethod.get,
      authorized: true,
      queryParams: {"due_from": dueFrom},
    );
    Map<String, dynamic> response = await request.sendRequest();

    return HomeWorkModel.fromJsonList(response);
  }

  Future<HomeWorkDetailsModel> getHomeWorkDetails(int id) async {
    Request request = Request(EndPoints.homeworkDetail(id), RequestMethod.get,
        authorized: true);
    Map<String, dynamic> response = await request.sendRequest();
    return HomeWorkDetailsModel.fromJson(response["data"]);
  }

  Future<void> downloadAttachment(int id, String name) async {
    File file = File('');
    if (Platform.isAndroid) {
      var status = await Permission.storage.status;
      if (status != PermissionStatus.granted) {
        status = await Permission.storage.request();
      }
      if (status.isGranted) {
        const downloadsFolderPath = '/storage/emulated/0/Download/';
        Directory dir = Directory(downloadsFolderPath);
        file = File('${dir.path}/$name');
      }
    }
    // Permission.storage;
    // Directory? appDocDir =
    //     await getApplicationDocumentsDirectory();

    String filePath = file.path;
    Dio().download(onReceiveProgress: (received, total) {
      if (total != -1) {
        print("${(received / total * 100).toStringAsFixed(0)}%");
      }
    },
        options: Options(
          headers: {
            "Authorization": "Bearer "
                '${Get.find<AuthController>().token}',
          },
        ),
        "https://lbbis-back.incentive-dev.com/api/attachment/$id",
        filePath);
  }
}
