import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';

import '../models/subject_response.dart';

class SubjectService {
  Future<List<SubjectResponse>> getSubjects(String gradId) async {
    Request request = Request(EndPoints.getAllSubjects, RequestMethod.get,
        authorized: true,
        queryParams: {
          'registration_record_id': gradId,
        });
    Map<String, dynamic> response = await request.sendRequest();

    return SubjectResponse.fromJsonList(response, 'subjects');
  }
}
