
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:syncfusion_flutter_datepicker/datepicker.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';

class CalenderWidget extends StatelessWidget {
  final void Function(DateRangePickerSelectionChangedArgs)? onSelectionChanged;
   
   DateTime? selectedDate;
  CalenderWidget({Key? key, required this.onSelectionChanged}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    DateTime currentDate = DateTime.now();
    return Container(
      // alignment: Alignment.center, // Aligning the container's content to the center
      margin: const EdgeInsets.only(top: 10),
      // padding: const EdgeInsets.only(top: 0),
      decoration: BoxDecoration(
        //border: Border.all(color: AppColors.primeColor),
        borderRadius: BorderRadius.circular(18),
        color: AppColors.quizItem,
        boxShadow: [
          BoxShadow(
            color: AppColors.quizShadow,
            blurRadius: 6,
          ),
        ],
      ),
      height: 240,
      width: Get.width * .85,
      child: SfDateRangePicker(
        cellBuilder: (BuildContext context, DateRangePickerCellDetails cellDetails) {
            final bool isCellSelected = selectedDate != null &&
                  cellDetails.date.year == selectedDate!.year &&
                  cellDetails.date.month == selectedDate!.month &&
                  cellDetails.date.day == selectedDate!.day;
             final bool isCurrentDate = cellDetails.date.year == currentDate.year &&
                  cellDetails.date.month == currentDate.month &&
                  cellDetails.date.day == currentDate.day;
               return
                 Center(
                   child: Container(
                     decoration: BoxDecoration(
                       shape: BoxShape.circle,
                       // Set the shape to circle
                       border: Border.all(
                         color:  isCurrentDate ||  isCellSelected
                          ? AppColors.primeColor // Set your desired border color for current date and selected date
                          : Colors.transparent, // Set the border color for other dates
                       ),
                     ),
                     child: Text(
                       cellDetails.date.day.toString(),
                       style: TextStyle(
                         color: isCurrentDate ||  isCellSelected
                          ? AppColors.primeColor // Set your desired text color for current date and selected date
                          : Colors.black, // Set the text color for other dates
                         fontWeight: FontWeight.normal, // Set your desired font weight
                         fontSize: 16, // Set your desired font size
                       ),
                     ),
                   ),
                 );
            },
         // Setting the initial view to month
        onSelectionChanged: (DateRangePickerSelectionChangedArgs args) {
          // Update the selected date when a new date is selected
          selectedDate = args.value;
          // Call the onSelectionChanged callback if it is provided
          if (onSelectionChanged != null) {
            onSelectionChanged!(args);
          }
        },
        allowViewNavigation: true,
        enablePastDates: true,
        maxDate: DateTime(currentDate.year + 1),
        initialSelectedDate: DateTime.now(),
        minDate: DateTime(currentDate.year - 1),
        showNavigationArrow: true,
        selectionColor: Colors.transparent,
        selectionShape: DateRangePickerSelectionShape.circle,
        todayHighlightColor: AppColors.primeColor,
        headerStyle: DateRangePickerHeaderStyle(
          textAlign: TextAlign.start,
          textStyle: TextStyle(
            color: AppColors.newPrimeColor,
            fontWeight: FontWeight.bold,
          ),
        ),
        // monthCellStyle: DateRangePickerMonthCellStyle(
        //   textStyle:  TextStyle(
        //     textAlign: TextAlign.center,
        //   ),
        // ),

      ),
    ).center();
  }
}
