import '../../../../common/constant/colors.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:table_calendar/table_calendar.dart';

class CustomTableCalendarWidget extends StatefulWidget {
  const CustomTableCalendarWidget({Key? key, required this.onDayChanged}) : super(key: key);
  final Function(DateTime) onDayChanged;

  @override
  _CustomTableCalendarWidgetState createState() => _CustomTableCalendarWidgetState();
}

class _CustomTableCalendarWidgetState extends State<CustomTableCalendarWidget> {
  DateTime _selectedDay = DateTime.now();

  final HeaderStyle _headerStyle = HeaderStyle(
    formatButtonVisible: false,
    titleCentered: true,
    titleTextStyle: const TextStyle(fontSize: 28),
    titleTextFormatter: (date, locale) => DateFormat('MMM').format(date),
    leftChevronIcon: Container(
      padding: const EdgeInsets.all(4),
      decoration: BoxDecoration(
        color: AppColors.primeColor,
        borderRadius: BorderRadius.circular(10),
      ),
      child: const Icon(
        Icons.arrow_back,
        color: Colors.white,
        size: 36,
      ),
    ),
    rightChevronIcon: Container(
      padding: const EdgeInsets.all(4),
      decoration: BoxDecoration(
        color: AppColors.primeColor,
        borderRadius: BorderRadius.circular(10),
      ),
      child: const Icon(
        Icons.arrow_forward,
        color: Colors.white,
        size: 36,
      ),
    ),
    leftChevronMargin: const EdgeInsets.only(left: 36),
    rightChevronMargin: const EdgeInsets.only(right: 36),
  );

  final DaysOfWeekStyle _daysOfWeekStyle = DaysOfWeekStyle(
    decoration: BoxDecoration(color: AppColors.primeColor),
    weekdayStyle: const TextStyle(color: Colors.white, fontSize: 18),
    weekendStyle: const TextStyle(color: Colors.white, fontSize: 18),
  );

  final CalendarStyle _calenderStyle = CalendarStyle(
    selectedDecoration: BoxDecoration(shape: BoxShape.circle, color: AppColors.primeColor),
    todayDecoration: BoxDecoration(shape: BoxShape.circle, color: AppColors.primeColor.withAlpha(150)),
    markersAlignment: Alignment.center,
    defaultDecoration: BoxDecoration(shape: BoxShape.circle, color: AppColors.secondaryColor),
  );

  @override
  Widget build(BuildContext context) {
    return TableCalendar(
      firstDay: DateTime.now().subtract(const Duration(days: 400)),
      lastDay: DateTime.now(),
      focusedDay: _selectedDay,
      headerStyle: _headerStyle,
      calendarStyle: CalendarStyle(
        selectedDecoration: BoxDecoration(shape: BoxShape.circle, color: AppColors.primeColor),
        todayDecoration: BoxDecoration(shape: BoxShape.circle, color: AppColors.primeColor.withAlpha(150)),
        markersAlignment: Alignment.center,
        cellMargin: const EdgeInsets.all(0),
      ),
      daysOfWeekHeight: 40,
      daysOfWeekStyle: _daysOfWeekStyle,
      rowHeight: 36,
      selectedDayPredicate: (day) {
        return isSameDay(_selectedDay, day);
      },
      onDaySelected: (selectedDay, focusedDay) {
        setState(() {
          _selectedDay = selectedDay;
          widget.onDayChanged(selectedDay);
        });
      },
    );
  }
}
