

import '../../../calender/data/models/attachment.dart';


class MailResponse {
  int id;
  String title;
  bool received;
  String message;
  String date;
  List<AttachmentModel> attachments;
  int read;



  MailResponse(
      {
      required this.id,
      required this.title,
      required this.received,
      required this.message,
      required this.date,
      required this.attachments,
      required this.read,
      });
  factory MailResponse.zero() => MailResponse(
        id: 0,
        title: '',
        received: false,
        message: '',
        date: '',
        read: 0,
        attachments: [],
      );

  factory MailResponse.fromJson(Map<String, dynamic> json) =>
      MailResponse(
        id: json["id"],
        title: json["title"] ?? 'none',
        received: json["received"],
        message: json["message"],
        date: json["date"],
        attachments: AttachmentModel.fromJsonList(json),
        read: json["read"],
      );


   static List<MailResponse> fromJsonList(Map<String, dynamic> json) {
    List<MailResponse> mails = [];
    json["data"]
        .forEach((element) => mails.add(MailResponse.fromJson(element)));
    return mails;
  }


}
