class TeacherChat {
  TeacherChat({
    required this.user_id,
    required this.name,
    required this.image,
    required this.specialization,
  });

  int user_id;
  String name;
  dynamic image;
  String specialization;
 

  factory TeacherChat.fromJson(Map<dynamic, dynamic> json) => TeacherChat(
        user_id: json["user_id"],
        name: json["name"],
        image: json["image"],
        specialization: json["specialization"],
      );

  Map<dynamic, dynamic> toJson() => {
        "user_id": user_id,
        "name": name,
        "image": image,
        "specialization": specialization,
      };
  factory TeacherChat.zero({String? name}) => TeacherChat(
      user_id: 0,
      name: name ?? '',
      image: '',
      specialization: '',);

  static List<TeacherChat> fromJsonList(Map<dynamic, dynamic> json, String key) {
    List<TeacherChat> teacherChat = [];
    if (json[key] == null) {
      return [];
    }
    try {
      json[key].forEach((teachers) {
        print(teachers);
        teacherChat.add(TeacherChat.fromJson(teachers));
      });
    } catch (e) {
      print(e.toString());
    }
    return teacherChat;
  }
}
