import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/chat/data/model/mail.dart';
import '../../../../features/chat/data/model/mail_responce.dart';
import '../../../../features/chat/data/model/teacher.dart';

class TeacherChatService {
  Future<List<TeacherChat>> getTeacherChat({
    required String registrationRecordId,
  }) async {
    Request request = Request(
      EndPoints.getTeachers,
      RequestMethod.get,
      queryParams: {
        "registration_record_id": registrationRecordId,
      },
      authorized: true,
    );
    Map<dynamic, dynamic> response = await request.sendRequest();
    // print("object");
    // print("object");
    // print(response);
    // print("object");
    // print("object");
    List<TeacherChat> data = TeacherChat.fromJsonList(response, 'teachers');
    // print("object");
    // print("object");
    print(data);
    // print("object");
    // print("object");
    return data;
  }

  Future<List<MailResponse>> getMailChat({
    required int teacherId,
  }) async {
    Request request = Request(
      EndPoints.sendMail,
      RequestMethod.get,
      queryParams: {
        "teacher_id": teacherId,
        "order_by": 'created_at'
      },
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    
     return MailResponse.fromJsonList(response);
  }

 Future<void> sendMail(
   MailRequest mailRequest
  ) async {
    
    Request request = Request(
      EndPoints.sendMail,
      RequestMethod.post,
      formData: mailRequest.toFormData(),
      authorized: true,
      
    );
    dynamic response = await request.sendRequest();
  
  }

}
