import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/chat/business_logic/chat_controller.dart';
import '../../../../features/chat/data/model/mail.dart';
import '../../../../features/chat/data/model/mail_responce.dart';
import '../../../../features/chat/data/model/teacher.dart';
import '../../../../common/widgets/Error_view.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../auth/business_logic/auth_controller.dart';
import '../../../home/business_logic/home_controller.dart';

class ChatPage extends StatelessWidget {
  final ChatController chatController = Get.put(ChatController());
  final TextEditingController _messageController = TextEditingController();
  
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  TeacherChat teacher = Get.arguments;

  ChatPage({super.key});

  final scrollController = ScrollController();

  void loadData() async {

    await chatController.getMails(teacher.user_id);
  }
  @override
  Widget build(BuildContext context) {
    loadData();
    chatController.selectedFiles = [];
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)
      ),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBarWidget(
          title: teacher.name.tr,
        ),
        body: SingleChildScrollView(
          child: SizedBox(
            height: Get.height * 0.894 ,//800,
            child: Column(
              children: [
                Container(
                    height: Get.height * 0.76,
                    child: Obx(() {
                      if (chatController.getMailResponseModel.loading) {
                        return const CircularProgressIndicatorWidget();
                      }
                      if (chatController.getMailResponseModel.hasError) {
                        return ErrorView(onRetry: () {
                          chatController.getMails(teacher.user_id);
                        });
                      } else {
                        return Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Expanded(
                              child: ListView.builder(
                                itemCount: chatController.mails.length,
                                itemBuilder: (context, index) {
                                  MailResponse mail =
                                  chatController.mails[index];
                                  return
                                    Align(
                                      alignment: mail.received == false ? AlignmentDirectional.centerStart : AlignmentDirectional.centerEnd,
                                      child: Padding(
                                        padding: mail.received == false ? EdgeInsets.only(left: Get.width * 0.01, right: Get.width * 0.1) : EdgeInsets.only(left: Get.width * 0.1, right: Get.width * 0.01),
                                        child: Column(
                                          crossAxisAlignment: mail.received == false ? CrossAxisAlignment.start : CrossAxisAlignment.end,
                                          children: [
                                            Container(
                                              padding: EdgeInsets.all(Get.width * 0.02),
                                              decoration: BoxDecoration(
                                                  color: mail.received == false ? const Color.fromRGBO(212, 181, 179, 0.9) : const Color.fromRGBO(217, 217, 217, 0.8),
                                                  border: const Border(
                                                      bottom: BorderSide(color: Colors.green),
                                                      top: BorderSide(color: Colors.green),
                                                      left: BorderSide(color: Colors.green),
                                                      right: BorderSide(color: Colors.green)
                                                  ),
                                                  borderRadius: BorderRadius.circular(20),
                                                  shape: BoxShape.rectangle
                                              ),
                                              child: SizedBox(
                                                child: HeadTitleText(
                                                  mail.message,
                                                  fontFamily: AppFonts.alatsi,
                                                  size: 20,
                                                ),
                                              ),
                                            ),
                                            Text(mail.date)
                                          ],
                                        ),
                                      ),
                                    );
                                },
                              ),
                            ),
                          ],
                        );
                      }
                    })),
                SizedBox(height: Get.height * 0.01,),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 8.0),
                  child: Align(
                    alignment: AlignmentDirectional.bottomCenter,
                    child:
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SizedBox(
                          width: Get.width * 0.80,
                          child: TextField(
                            controller: _messageController,
                            cursorColor: AppColors.newPrimeColor,
                            keyboardType: TextInputType.multiline,
                            textInputAction: TextInputAction.newline,
                            minLines: 1,   
                            maxLines: 4,     
                            decoration: InputDecoration(
                              contentPadding: const EdgeInsets.symmetric(
                                horizontal: 20,
                                vertical: 14,
                              ),
                              enabledBorder: OutlineInputBorder(
                                borderRadius: BorderRadius.circular(40),
                                borderSide: const BorderSide(color: Colors.black),
                              ),
                              focusedBorder: OutlineInputBorder(
                                borderRadius: BorderRadius.circular(40),
                                borderSide: const BorderSide(color: Colors.black),
                              ),
                              hintText: 'Enter Message',
                            ),
                          ),
                        ),

                        IconButton(
                            onPressed: () async{
                              MailRequest mailRequest = MailRequest(
                                  title: authController.childrens[homeController.selectedChild.value].fullName,
                                  message: _messageController.text,
                                  files: chatController.selectedFiles,
                                  receiver_id: teacher.user_id,
                                  type: "mail");
                              await chatController.sendMail(mailRequest ,
                                onSuccess: () async {
                                  await chatController.getMails(teacher.user_id);
                                  RoutingManager.back();
                                },
                              );
                            },
                            icon: Icon(Icons.send, size: 30,)),
                      ],
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }
}