import '../../../../features/calender/data/models/subject_response.dart';
import '../../../../features/exam/data/models/mark_model.dart';

class ExamModel {
  String id;
  String name;
  int minMark;
  int maxMark;
  String date;
  MarkModel markModel;
  SubjectResponse subjectModel;
  ExamModel({
    required this.id,
    required this.name,
    required this.minMark,
    required this.maxMark,
    required this.date,
    required this.subjectModel,
    required this.markModel,
  });

  factory ExamModel.fromJson(Map<String, dynamic> json) => ExamModel(
        id: json['id'].toString(),
        name: json['name'],
        minMark: 0,
        maxMark: json['max_mark'],
        date: json['date'],
        subjectModel: SubjectResponse.fromJson(json['subject']),
        markModel: MarkModel.fromJson(json['mark']),
      );

  factory ExamModel.zero() => ExamModel(
        id: '',
        name: '',
        minMark: 0,
        maxMark: 0,
        date: '',
        subjectModel: SubjectResponse.zero(),
        markModel: MarkModel.zero(),
      );

  static List<ExamModel> fromJsonList(
    Map<String, dynamic> json,
    String key,
  ) {
    List<ExamModel> exams = [];

    if (json[key] == null) {
      return [];
    }

    try {
      json[key].forEach(
        (exam) => exams.add(
          ExamModel.fromJson(exam),
        ),
      );
    } catch (e) {
      print(e);
    }

    return exams;
  }
}
