class MarkModel {
  String id;
  int mark;
  String examId;
  String registrationRecord;
  String createdAt;
  String updatedAt;
  MarkModel({
    required this.id,
    required this.mark,
    required this.examId,
    required this.registrationRecord,
    required this.createdAt,
    required this.updatedAt,
  });

  factory MarkModel.fromJson(Map<String, dynamic> json) => MarkModel(
        id: json['id'].toString(),
        mark: json['mark'],
        examId: json['test_id'].toString(),
        registrationRecord: json['registration_record_id'].toString(),
        createdAt: json['created_at'] ?? '',
        updatedAt: json['updated_at'] ?? '',
      );

  factory MarkModel.zero() => MarkModel(
        id: '',
        mark: 0,
        examId: '',
        createdAt: '',
        updatedAt: '',
        registrationRecord: '',
      );
}
