import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/exam/data/models/exam_model.dart';

class ExamService {
  Future<List<ExamModel>> getExams(Map<String, dynamic> params) async {
    Request request = Request(
      EndPoints.getExamList,
      RequestMethod.get,
      authorized: true,
      queryParams: params,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return ExamModel.fromJsonList(response, 'tests');
  }

  Future<List<ExamModel>> lastExam(String registrationRecordId,
      {String? createdFrom, String? createdTo}) async{
    Request request = Request(
      queryParams: createdFrom != null
          ? {
        "from": "$createdFrom",
        "to": "$createdTo"
      } : null,
      EndPoints.getExamList,
      RequestMethod.get,
      authorized: true,

    );
    Map<String, dynamic> response = await request.sendRequest();
    return ExamModel.fromJsonList(response, 'tests');
  }
}
