import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/exam/data/models/exam_model.dart';

class ResultService {
  Future<List<ExamModel>> getResults(Map<String, dynamic> params) async {
    Request request = Request(
      EndPoints.getMarks,
      RequestMethod.get,
      authorized: true,
      queryParams: params,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return ExamModel.fromJsonList(response, 'data');
  }
}