import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/exam/business_logic/exam_controller.dart';
import '../../../../features/exam/presentation/widgets/exam_body.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../features/home/business_logic/home_controller.dart';

import '../../../../common/widgets/rx_view.dart';
import '../../../calender/business_logic/calender_controller.dart';

class ExamPage extends StatelessWidget {
  final ExamController examController = Get.put(ExamController());
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  final CalenderController calenderController = Get.find<CalenderController>();
  ExamPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        body: Padding(
          padding: EdgeInsets.symmetric(horizontal: Get.width * .05),
          child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                SizedBox(
                  // padding: EdgeInsets.only(bottom: 10),
                  // height: Get.height * .8,
                  // width: Get.width * .85,
                  child: Obx(() {
                    return RxView(
                    rxFuture: examController.examState,
                    onRetry: () {
                      examController.getExams({
                        'registration_record_id': authController
                            .childrens[homeController.selectedChild.value].id,
                        'date_from': DateTime.now(),
                      });
                    },
                    child: examController.examState.result.isEmpty
                        ? const EmptyView()
                        : ListView.builder(
                            itemCount: examController.examState.result.length,
                            itemBuilder: (BuildContext context, index) {
                              return ExamBodyWidget(
                                examModel: examController.examState.result[index],
                              );
                              // .onTap(() {
                              //   // RoutingManager.to(RoutesName.examDetails,arguments: );
                              // });
                            },
                          ),
                  );
                })).center().expanded(9)
          ]),
        ),
      ),
    );
  }
}
