import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/calender/data/models/subject_response.dart';
import '../../../../features/exam/business_logic/result_controller.dart';
import '../../../../features/home/business_logic/home_controller.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/dropdown.dart';
import '../../../calender/business_logic/calender_controller.dart';

class DropDownExam extends StatefulWidget {

  DropDownExam({super.key});

  @override
  State<DropDownExam> createState() => _DropDownExamState();
}

class _DropDownExamState extends State<DropDownExam> {

  ResultController resultControler = Get.find<ResultController>();

  CalenderController calenderController = Get.find<CalenderController>();

  AuthController authController = Get.find<AuthController>();

  HomeController homeController = Get.find<HomeController>();

  List<String> name = [];

  loadData() async{

    await resultControler.getExams({
      'registration_record_id':
      authController.childrens[homeController.selectedChild.value].id,
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    for (int i = 0; i < resultControler.examState.result.length; i++) {
      name.add(resultControler.examState.result[i].markModel.mark.toString());
    }

    return Container(
      alignment: Alignment.center,
      padding: const EdgeInsets.only(left: 10, right: 10),
      margin: const EdgeInsets.only(top: 15),
      width: Get.width * .85,
      height: 45,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(25),
          border: Border.all(color: AppColors.secondaryColor)),
      child: Obx(
        () {
          if (resultControler.examState.loading) {
            return const CircularProgressIndicatorWidget();
          }
          if (calenderController.subjectState.result.isEmpty) {
            return const EmptyView(
              haveImage: false,
            ).paddingOnly(top: 10);
          } else {
            return DropDownWidget<SubjectResponse>(
                padding: const EdgeInsets.only(bottom: 0),
                margin: const EdgeInsets.only(bottom: 5),
                item: calenderController.subjectState.result,
                toStr: (subject) => subject.name,
                compareFunction: (t1, t2) {
                  return t1.compare(t2);
                },
                onChanged: (value) {
                  resultControler.subject = value!;
                  resultControler.getExams({
                    'registration_record_id': authController
                        .childrens[homeController.selectedChild.value].id,
                    'subject': value.id
                  });
                },
                selectItem: resultControler.subject.id.isEmpty
                    ? calenderController.subjectState.result[0]
                    : resultControler.subject);
          }
        },
      ),
    );
  }
}
