import 'package:flutter/material.dart';
import 'package:get/get.dart';


import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/text.dart';
import '../../data/models/exam_model.dart';

class ExamBodyWidget extends StatelessWidget {
  final String locale = Get.deviceLocale.toString();
  final ExamModel examModel;
  ExamBodyWidget({super.key, required this.examModel});

  @override
  Widget build(BuildContext context) {
    print('ere$locale');
    return Container(
      margin: const EdgeInsets.only(bottom: 20 , top: 10),
      width: Get.width * .85,
      height: 250,
      decoration: BoxDecoration(
          border: Border.all(color: AppColors.primeColor),
          borderRadius: BorderRadius.circular(10)),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  TextTitle(
                    'Exam Name: ${examModel.name}'.tr,
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    'Subject: ${examModel.subjectModel.name}'.tr,
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    'Greater Point: ${examModel.maxMark}'.tr,
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    'Date: ${examModel.date.tr}',
                    textColor: AppColors.secondaryColor,
                  ),
                ],
              ),
             
            ],
          ).paddingSymmetric(horizontal: 10, vertical: 16),
          SizedBox(
            width: Get.width * 0.72,
            height: 15,
            child: Divider(
              color: AppColors.primeColor,
              thickness: 1,
            ),
          ).paddingSymmetric(horizontal: 20),
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              TextTitle(
                'Description:'.tr,
                textColor: AppColors.secondaryColor,
              ),
              NormalText(
                examModel.name.tr,
                textColor: AppColors.appBlack.withOpacity(0.5),
              )
            ],
          ).paddingSymmetric(horizontal: 8),
        ],
      ),
    );
  }
}
