import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/widgets/percent_exam.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/text.dart';
import '../../data/models/exam_model.dart';

class ResultBodyWidget extends StatelessWidget {
  final String locale = Get.deviceLocale.toString();
  final ExamModel examModel;
  ResultBodyWidget({super.key, required this.examModel});

  @override
  Widget build(BuildContext context) {
    print('ere$locale');
    return Container(
      margin: const EdgeInsets.only(bottom: 20 , top: 10),
      width: Get.width * .85,
      height: 250,
      decoration: BoxDecoration(
          border: Border.all(color: AppColors.primeColor),
          borderRadius: BorderRadius.circular(10)),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  TextTitle(
                    '${'Exam Name'.tr}:${examModel.name.tr}',
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    '${'Subject'.tr}:${examModel.subjectModel.name.tr}',
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    '${'Greater Point'.tr}:${examModel.maxMark}'.tr,
                    textColor: AppColors.secondaryColor,
                  ),
                  TextTitle(
                    '${'Date:'.tr}${examModel.date.tr}',
                    textColor: AppColors.secondaryColor,
                  ),
                ],
              ),
              Padding(
                padding: const EdgeInsets.only(top: 16, right: 0, left: 0),
                child: Align(
                  alignment: locale == 'ar_AE'
                      ? Alignment.topLeft
                      : Alignment.topRight,
                  child: PercentExamWidget(
                    examModel: examModel,
                  ),
                ),
              )
            ],
          ).paddingSymmetric(horizontal: 10, vertical: 16),
          SizedBox(
            width: Get.width * 0.72,
            height: 15,
            child: Divider(
              color: AppColors.primeColor,
              thickness: 1,
            ),
          ).paddingSymmetric(horizontal: 20),
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              TextTitle(
                'Description:'.tr,
                textColor: AppColors.secondaryColor,
              ),
              NormalText(
                examModel.name.tr,
                textColor: AppColors.appBlack.withOpacity(0.5),
              )
            ],
          ).paddingSymmetric(horizontal: 8),
        ],
      ),
    );
  }
}
