

import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../features/purchase/api_res.dart';
import '../../../../features/purchase/models/buffet_card_model.dart';
import '../../../../features/restaurant/data/source/restaurant_web.dart';
import '../../../common/widgets/snack_bar_widget.dart';
import '../../../core/local storage/local_storage.dart';
import '../../exam/data/models/exam_model.dart';
import '../../exam/data/service/exams_service.dart';
import '../../exam/data/service/marks_service.dart';
import '../../notes/data/model/note.dart';
import '../../notes/data/service/note_service.dart';
import '../../notification/data/model/notification.dart';
import '../../notification/data/service/notifications_service.dart';
import '../../restaurant/data/model/meal.dart';

class HomeController extends GetxController {
  NotificationService notificationService = NotificationService();
  RxFuture<List<NotificationResponse>> state =
      RxFuture(<NotificationResponse>[]);
  Future<void> getNotification() async {
    await state.observe((value) async {
      return await notificationService.getNotifications();
    });
  }

  ResultService resultService = ResultService();
  RxFuture<List<ExamModel>> resultState = RxFuture(<ExamModel>[]);
  Future<void> getLatestResult(Map<String, dynamic> params) async {
    await resultState.observe((p0) async {
      return await resultService.getResults(params);
    });
  }

  ExamService examService = ExamService();
  RxFuture<List<ExamModel>> examState = RxFuture(<ExamModel>[]);
  Future<void> getLatestExam(Map<String, dynamic> params) async {
    await examState.observe((p0) async {
      return await examService.getExams(params);
    });
  }

  //get latest note
  RxFuture<List<NoteResponse>> notesState = RxFuture([]);
  NoteService noteService = NoteService();
  Future<void> getNotes(Map<String, dynamic> params) async {
    await notesState.observe(
      (_) async {
        return await noteService.getNotes(params);
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
  }

  RxInt selectedChild = 0.obs;
  LocalStorage storage = LocalStorage();
  Future<void> saveSelectedChild(int r) async {
    await storage.saveSelectedChild(r);
    print("YYYYYYYYYYYYYYYyy");
    print(r);

    print("****************************");
  }

 

  RestaurantWebService restaurantWebService = RestaurantWebService();
  RxFuture<StudentMeal> getLatestMealState = RxFuture(StudentMeal.zero('', ''));
  Future<void> getLatestMeal(String registrationRecordId) async {
    await getLatestMealState.observe(
      (_) async {
        return await restaurantWebService.getLatestMeal(
            registrationRecordId, DateTime.now());
      },
     
    );
  }

  RestaurantWebService buffettWebService = RestaurantWebService();
  RxFuture<BuffetCardModel> getBuffetState = RxFuture(BuffetCardModel.zero('', ''));
  Future<void> getBuffetCard(String registrationRecordId) async {
    await getBuffetState.observe(
      (_) async{
      ApiResponse response = await buffettWebService.getBuffetCard(
        childId: registrationRecordId,
      );
        print(response.data);
        BuffetCardModel buffetCard = BuffetCardModel.fromJson(response.data);
        return buffetCard;
    },
     
    );
  }


  

  // RestaurantWebService restaurantRepo = RestaurantWebService();

  // // ------------- Rx Variables -------------

  // GetMealsEntity getMealsRequestModel = GetMealsEntity.zero();

  // RxFuture<List<MealModel>> getMealsResponseModel = RxFuture(<MealModel>[]);

  // // ------------- Setters -------------

  // void setRegistrationRecord(String registrationRecordId) {
  //   getMealsRequestModel.registrationRecordId = registrationRecordId;
  //   log('sssssssssssssss : ${getMealsRequestModel.registrationRecordId}');
  // }

  // // ------------- Methods -------------

  // Future<void> getLatestMeals() async {
  //   getMealsResponseModel.observe((_) async {
  //     return await restaurantRepo.getLatestMeal(
  //       registrationRecordId: getMealsRequestModel.registrationRecordId,
  //       date: DateTime.now(),
  //       // dateFrom: getMealsRequestModel.dateFrom,
  //       // dateTo: getMealsRequestModel.dateTo,
  //     );
  //   });
  // }
}
