import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import '../../../../../../core/local%20storage/local_storage.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/chat/business_logic/chat_controller.dart';
import '../../../../../../features/exam/business_logic/result_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/home/common/changeIndexNotifier.dart';
import '../../../../../../features/home/common/constant.dart';
import '../../../../../../features/home/presentation/screens/mainScreen.dart';
import '../../../../../../features/home/presentation/screens/pages/webViewAppScreen.dart';
import '../../../../../../features/home/presentation/screens/pages/food.dart';
import '../../../../../../features/home/presentation/screens/pages/weeklySchedule/weeklySchedule.dart';
import '../../../../../../features/home/presentation/widgets/chooseUser.dart';
import '../../../../../../features/new_purchase/buisness_logic/new_purchase_controller.dart';
import '../../../../../../features/notes/business_logic/note_controller.dart';
import '../../../../../../features/setting/presentation/screens/setting_page.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/wallet/presentation/screen/home_wallet.dart';
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../calender/business_logic/calender_controller.dart';
import '../../../exam/business_logic/exam_controller.dart';
import '../../../notification/business_logic/notification_controller.dart';
import '../../../restaurant/business_logic/restaurant_controller.dart';
import '../../../../../../common/extensions/date.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import '../../../variable/business_logic/variable_controller.dart';

class HomePageScreen extends StatefulWidget {
  HomePageScreen({super.key});
  @override
  State<HomePageScreen> createState() => _HomePageScreenState();
}

class _HomePageScreenState extends State<HomePageScreen> {
  String? typeUser;
  bool select = false;
  String date = DateFormat('yyyy-MM-dd').format(DateTime.now());
  bool isLoad1 = false;
  bool isLoad2 = false;
  bool isLoad3 = false;
  CalenderController calenderController = Get.put(CalenderController());
  NotificationController notificationController = Get.find<NotificationController>();
  ExamController examController = Get.find<ExamController>();
  ResultController resultController = Get.find<ResultController>();
  VariableController variableController = Get.put(VariableController());
  ChatController chatController = Get.put(ChatController());
  HomeController homeController = Get.find<HomeController>();
  NoteController noteController = Get.find<NoteController>();
  AuthController authController = Get.find<AuthController>();
  NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();
  RestaurantController restaurantController = Get.find<RestaurantController>();
  WalletController walletController = Get.find<WalletController>();
  NewPurchaseController newPurchaseController = Get.find<NewPurchaseController>();
  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());

  void loadData() async {
    authController.fillChildrenFromStorage();
    homeController.getNotification();
    if (authController.childrens.isNotEmpty && homeController.selectedChild.value < authController.childrens.length) {
      authController.childrens[homeController.selectedChild.value];
      restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
      homeController.getBuffetCard(authController.childrens[homeController.selectedChild.value].id);
      await homeController.getNotes(
        {
          'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
          'from_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
          'to_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
        },
      );
      homeController.getLatestExam({'registration_record_id': authController.childrens[homeController.selectedChild.value].id});
      calenderController.homeworkDelivery(
        authController.childrens[homeController.selectedChild.value].id,
        dueFrom: DateTime.now().toString().substring(0, 10),
      );
      await newWeeklyController.getSubjectTable( authController.childrens[homeController.selectedChild.value].id,
        date: DateTime.parse(date).toDay().toLowerCase().toString());
      await newPurchaseController.getPurchaseTable(authController.childrens[homeController.selectedChild.value].id);
    }
  }

  @override
  void initState() {
    super.initState();
    typeUser = LocalStorage().userTypeUser;
  }

  @override
  Widget build(BuildContext context) {
    return RefreshIndicator(
      color: AppColors.newPrimeColor,
      backgroundColor: AppColors.newSecondaryColor,
      onRefresh: () async {
        loadData();
      },
      child: Container(
        decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage( image: AssetImage('asset/images/backGroundLogIn1.png'), fit: BoxFit.cover)),
        child: Consumer<ChangeIndexNotifier>(
          builder: (context,indexNotifier,child){
            return Scaffold(
              backgroundColor: Colors.transparent,
              appBar: AppBar(
                backgroundColor: Colors.transparent,
                scrolledUnderElevation: 0,
                leading: Row(
                  children: [
                    Padding(
                      padding: EdgeInsets.only(left: Get.width * 0.02),
                      child: Obx(() {
                        return CircleAvatar(
                          radius: 30,
                          backgroundImage: authController.childrens[
                          homeController.selectedChild.value].photo!.isNotEmpty
                            ? NetworkImage(authController.childrens[homeController.selectedChild.value].photo!)
                            : authController.childrens[homeController.selectedChild.value].gender == "male"
                            ? const AssetImage('asset/images/Profile-Boy.png')
                            : const AssetImage("asset/images/Profile-Girl.png") as ImageProvider)
                          .padding(padding: const EdgeInsets.only(top: 10),
                        );
                      }),
                    ),
                    Container(
                      color: Colors.transparent,
                      alignment: Alignment.topCenter,
                      height: Get.height * .12,
                      child: ChooseUser(),
                    ).expanded(1),
                  ],
                ),
                leadingWidth: 200,
                actions: [
                  IconButton(
                    icon: Icon(
                      CupertinoIcons.bell_fill,
                      color: AppColors.newPrimeColor,
                    ),
                    onPressed: () async {
                      await notificationController.getNotifications();
                      RoutingManager.to(RoutesName.notificationPage);
                    },
                  ),
                  Padding(
                    padding: const EdgeInsets.only(right: 8.0),
                    child: IconButton(
                      icon: Icon(CupertinoIcons.chat_bubble_fill,color: AppColors.newPrimeColor),
                      onPressed: () async {
                        chatController.setRegistrationRecord(authController.childrens[homeController.selectedChild.value].id,);
                        await chatController.getTeachers();
                        RoutingManager.to(RoutesName.chatTeacherPage);
                      },
                    ),
                  ),
                ],
              ),
              body: _getBody(indexNotifier),
              floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,
              floatingActionButton: FloatingActionButton(
                elevation: 0.0,
                backgroundColor: const Color.fromRGBO(217, 217, 217, 1),
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(50),
                ),
                child:
                Icon(Icons.home_filled, size: 30, color: AppColors.newPrimeColor),
                onPressed: () {
                  indexNotifier.setIndex(0);
                },
              ),
              bottomNavigationBar: BottomAppBar(
                height: Get.height * .074,
                color: AppColors.newPrimeColor,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  mainAxisSize: MainAxisSize.max,
                  children: [
                    Padding(
                      padding: EdgeInsets.only(left: Get.width * 0.01, right: Get.width * 0.01),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          GestureDetector(
                            onTap: typeUser == 'parent' ? () async{
                              await walletController.getFinanceDoneInfo();
                              await walletController.getFinanceToPayInfo();
                              await walletController.getDigitalWalletBalanceDetail();
                              indexNotifier.setIndex(1);
                            } : null ,
                            child: Obx((){
                              return walletController.financeDoneState.loading
                                ? CircularProgressIndicator( backgroundColor: Colors.white, color: AppColors.quizShadow,)
                                : Container(
                                  width: Get.width * 0.14,
                                  decoration: const BoxDecoration(
                                    color: Colors.transparent,
                                    image: DecorationImage(image: AssetImage('asset/icons/wallet(1).png'))),
                              );
                            })
                          ),
                          SizedBox(width: Get.width * 0.09,),
                          GestureDetector(
                            onTap:  ()  async {
                              restaurantController.setRegistrationRecord(authController.childrens[homeController.selectedChild.value].id,);
                              restaurantController.studentMeals.clear();
                              await restaurantController.getStudentMeals();
                              await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
                              indexNotifier.setIndex(2);
                            }  ,
                            child: Obx(() {
                              return restaurantController.getMealsResponseModel.loading
                                  ? CircularProgressIndicator(
                                backgroundColor: Colors.white,
                                color: AppColors.quizShadow,
                              )
                                  : Container(
                                width: Get.width * 0.14,
                                decoration: const  BoxDecoration(
                                    color: Colors.transparent,
                                    image: DecorationImage(
                                        image: AssetImage('asset/icons/newFood2.png')))
                                ,);
                            })
                          )
                        ],
                      ),
                    ),
                    Padding(
                      padding: EdgeInsets.only(left: Get.width * 0.01, right: Get.width * 0.01),
                      child: Row(
                        children: [
                          GestureDetector(
                            onTap: () {
                              RoutingManager.to(RoutesName.website);
                            },
                            child: Container(
                              width: Get.width * 0.14,
                              decoration: const BoxDecoration(
                                color: Colors.transparent,
                                image: DecorationImage(image: AssetImage('asset/icons/mobile-app.png'))),
                            )
                          ),
                          SizedBox(width: Get.width * 0.09,),
                          GestureDetector(
                            child: isLoad3
                                ? CircularProgressIndicator(
                              backgroundColor: Colors.white,
                              color: AppColors.quizShadow,
                            )
                                : Container(
                              width: Get.width * 0.14,
                              decoration: BoxDecoration(
                                color: Colors.transparent,
                                image: DecorationImage(
                                    image: select
                                        ? const AssetImage(
                                        'asset/icons/selectedMain.png')
                                        : const AssetImage(
                                        'asset/icons/unSelectedMain.png')),
                              ),
                            ),
                            onTap: () {
                              showModalBottomSheet(
                                  context: context,
                                  useRootNavigator: true,
                                  builder: (BuildContext context){
                                    return Container(
                                        height: 409,
                                        width: 393,
                                        child: Column(
                                          mainAxisAlignment: MainAxisAlignment.center,
                                          children: [
                                            GestureDetector(
                                              onTap: () {
                                                RoutingManager.to(RoutesName.calenderPage);
                                              },
                                              child: Row(
                                                // mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/calender1.png')),
                                                  ),
                                                  HeadTitleText(
                                                      'Calender'.tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.074/*35*/:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            GestureDetector(
                                              onTap: () async{
                                                await examController.getExams({
                                                  'registration_record_id': authController
                                                      .childrens[homeController.selectedChild.value].id,
                                                  'date_from': DateTime.now(),
                                                });
                                                await resultController.getExams({
                                                  'registration_record_id': authController
                                                      .childrens[homeController.selectedChild.value].id,
                                                });
                                                RoutingManager.to(RoutesName.mainExamPage);
                                              },
                                              child: Row(
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/exam.png')),
                                                  ),
                                                  HeadTitleText(
                                                      "Exams".tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.074/*35*/:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            GestureDetector(
                                              onTap: (){
                                                if(typeUser == 'parent')
                                               {RoutingManager.to(RoutesName.notePage);}
                                              },
                                              child: Row(
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/note.png')),
                                                  ),
                                                  HeadTitleText(
                                                      "Notes".tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.074/*35*/:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            GestureDetector(
                                              onTap: () async {
                                                 await variableController.getPersonalVariableInfo(authController.childrens[homeController.selectedChild.value].id, 'registration_record_id');
                                                 await variableController.getAllVariableInfo(authController.childrens[homeController.selectedChild.value].id, 'mobile_registration_record');
                                                 RoutingManager.to(RoutesName.variable);//
                                              },
                                              child: Row(
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/variable.png')),
                                                  ),
                                                  HeadTitleText(
                                                      "Variable".tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.074/*35*/:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            GestureDetector(
                                              onTap: (){
                                                RoutingManager.to(RoutesName.settingPage);
                                              },
                                              child: Row(
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/setting.png')),
                                                  ),
                                                  HeadTitleText(
                                                      "Setting".tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.074/*35*/:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            GestureDetector(
                                              onTap: () async {
                                                if(typeUser == 'parent') {
                                                  await walletController.getFinanceDoneInfo();
                                                await walletController.getFinanceToPayInfo();
                                                await walletController.getDigitalWalletBalanceDetail();
                                                indexNotifier.setIndex(1);
                                                }
                                              },
                                              child: Row(
                                                children: [
                                                  Container(
                                                    height: Get.height * 0.03,//22,
                                                    width: Get.width * 0.06,//24,
                                                    child: Image(image: AssetImage('asset/images/walletColor.png')),
                                                  ),
                                                  HeadTitleText(
                                                      "Digital Wallet".tr,
                                                      color: AppColors.newPrimeColor,
                                                      fontFamily: AppFonts.alatsi).padding(padding: EdgeInsets.only(left: isArabic()? 0:10, right: isArabic()? 10:0))
                                                ],
                                              ),
                                            ).padding(padding: EdgeInsets.only(left: isArabic() ? 0:Get.width * 0.074/*35*/, right: isArabic() ? Get.width * 0.075:0)),
                                            Divider(
                                              color: AppColors.newPrimeColor,
                                              endIndent: 40,
                                              thickness: 1,
                                            ),
                                            TextButton(
                                                onPressed: (){
                                                  Navigator.pop(context);
                                                },
                                                child: const Text('close')),
                                          ],
                                        )
                                    );
                                  });
                            },
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            );
          },

        ),
      ),
    );
  }

   Widget _getBody(ChangeIndexNotifier index) {
    return ListenableBuilder(
      listenable: index,
      builder: (BuildContext context, Widget? child){
        switch(index.currentIndex){
          case 0:
            return const MainScreen();
          case 1:
            return const HomeWallet();
          case 2:
            return const Food(); 
          case 3:
            return WebViewApp();
          case 4:
            return WeeklySchedule();
          // case 5:
          //   return ExamPage();     
          case 8: 
            return SettingPage(); 
        }
        return const Center(
          child: Text("There is no page builder for this index."),
        );
      },
    );
  }
  bool isArabic(){
    String currentLanguageCode = Get.locale.toString();
    if(currentLanguageCode == 'ar'){
      return true;
    }else{
      return false;
    }
  }
}