import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:http/http.dart' as http;
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/home/common/constant.dart';
import '../../../../../../features/home/presentation/screens/api.dart';

class WeeklySchedule extends StatefulWidget {
  WeeklySchedule({super.key});

  @override
  State<WeeklySchedule> createState() => _WeeklyScheduleState();
}

class _WeeklyScheduleState extends State<WeeklySchedule> {
  String nameDay = DateFormat('EEEE').format(DateTime.now());
  String formattedDate = DateFormat('d MMM y').format(DateTime.now());

  bool? isLoad;

  var day;
  var data;
  List<dynamic> sunday = [];
  List<dynamic> monday = [];
  List<dynamic> tuesday = [];
  List<dynamic> wednesday = [];
  List<dynamic> thursday = [];

  @override
  void initState() {
    super.initState();
    _getWeekData();
  }

  @override
  Widget build(BuildContext context) {
    return data == null
        ? Container(
            decoration: const BoxDecoration(
                color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
                image: DecorationImage(
                    image: AssetImage('asset/images/backGroundLogIn1.png'),
                    fit: BoxFit.cover)),
            child: Scaffold(
                appBar: AppBar(
                  backgroundColor: Colors.transparent,
                  leading: IconButton(
                    icon: const Icon(Icons.arrow_back),
                    color: AppColors.newPrimeColor,
                    onPressed: () {
                      Navigator.pop(context);
                    },
                  ),
                  title: HeadTitleText(
                    'weekly schedule'.toUpperCase(),
                    color: AppColors.newPrimeColor,
                    fontFamily: 'alatsi',
                  ).padding(
                      padding: const EdgeInsets.only(left: 60, bottom: 10)),
                ),
                backgroundColor: Colors.transparent,
                body: Center(
                    child: CircularProgressIndicator(
                  color: AppColors.newPrimeColor,
                  backgroundColor: AppColors.newSecondaryColor,
                ))),
          )
        : Container(
            decoration: const BoxDecoration(
                color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
                image: DecorationImage(
                    image: AssetImage('asset/images/backGroundLogIn1.png'),
                    fit: BoxFit.cover)),
            child: Scaffold(
              backgroundColor: Colors.transparent,
              appBar: AppBar(
                backgroundColor: Colors.transparent,
                leading: IconButton(
                  icon: const Icon(Icons.arrow_back),
                  color: AppColors.newPrimeColor,
                  onPressed: () {
                    Navigator.pop(context);
                  },
                ),
                title: HeadTitleText(
                  'weekly schedule'.toUpperCase(),
                  color: AppColors.newPrimeColor,
                  fontFamily: 'alatsi',
                ).padding(padding: const EdgeInsets.only(left: 60, bottom: 10)),
              ),
              body: SingleChildScrollView(
                child: Column(
                  children: [
                    Padding(
                      padding: const EdgeInsets.only(
                          left: 23.0, right: 23.0, top: 15),
                      child: Container(
                        width: 361,
                        height: 210,
                        decoration: BoxDecoration(
                          gradient: const LinearGradient(
                              begin: Alignment.centerRight,
                              end: Alignment.topRight,
                              colors: [
                                Color.fromRGBO(232, 211, 211, 1),
                                Color.fromRGBO(217, 217, 217, 1)
                              ]),
                          borderRadius: BorderRadius.circular(13.0),
                        ),
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                HeadTitleText(
                                  sunday[0]['day'].toUpperCase(),
                                  fontFamily: 'alatsi',
                                  color: AppColors.newPrimeColor,
                                  size: 20,
                                ), //.padding(padding: const EdgeInsets.only(top: 8)),
                                HeadTitleText(
                                  sunday[0]['date'],
                                  fontFamily: AppFonts.alatsi,
                                  color: Colors.black,
                                  size: 18,
                                )
                              ],
                            ).padding(
                                padding: const EdgeInsets.only(
                                    left: 23.0, right: 23.0, top: 8.0, bottom: 25)),
                            SizedBox(
                              height: 140,
                              child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount: sunday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          sunday[index]['order'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                        ).padding(
                                            padding:
                                                const EdgeInsets.only(left: 0)),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        height: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            sunday[index]['subject'].toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          sunday[index]['edu_class'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 15,
                                        ),
                                      ),
                                    ],
                                  ).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 22));
                                },
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.only(
                          left: 23.0, right: 23.0, top: 15),
                      child: Container(
                        width: 361,
                        height: 210,
                        decoration: BoxDecoration(
                          gradient: const LinearGradient(
                              begin: Alignment.centerRight,
                              end: Alignment.topRight,
                              colors: [
                                Color.fromRGBO(232, 211, 211, 1),
                                Color.fromRGBO(217, 217, 217, 1)
                              ]),
                          borderRadius: BorderRadius.circular(13.0),
                        ),
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                HeadTitleText(
                                  monday[0]['day'].toUpperCase(),
                                  fontFamily: 'alatsi',
                                  color: AppColors.newPrimeColor,
                                  size: 20,
                                ), //.padding(padding: const EdgeInsets.only(top: 8)),
                                HeadTitleText(
                                  monday[0]['date'],
                                  fontFamily: AppFonts.alatsi,
                                  color: Colors.black,
                                  size: 18,
                                )
                              ],
                            ).padding(
                                padding: const EdgeInsets.only(
                                    left: 23.0, right: 23.0, top: 8.0, bottom: 25)),
                            SizedBox(
                              height: 140,
                              child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount: monday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    // mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          monday[index]['order'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                        ).padding(
                                            padding:
                                                const EdgeInsets.only(left: 0)),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        height: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            monday[index]['subject'].toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          monday[index]['edu_class'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 15,
                                        ),
                                      ),
                                    ],
                                  ).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 22));
                                },
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.only(
                          left: 23.0, right: 23.0, top: 15),
                      child: Container(
                        width: 361,
                        height: 210,
                        decoration: BoxDecoration(
                          gradient: const LinearGradient(
                              begin: Alignment.centerRight,
                              end: Alignment.topRight,
                              colors: [
                                Color.fromRGBO(232, 211, 211, 1),
                                Color.fromRGBO(217, 217, 217, 1)
                              ]),
                          borderRadius: BorderRadius.circular(13.0),
                        ),
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                HeadTitleText(
                                  tuesday[0]['day'].toUpperCase(),
                                  fontFamily: 'alatsi',
                                  color: AppColors.newPrimeColor,
                                  size: 20,
                                ), //.padding(padding: const EdgeInsets.only(top: 8)),
                                HeadTitleText(
                                  tuesday[0]['date'],
                                  fontFamily: AppFonts.alatsi,
                                  color: Colors.black,
                                  size: 18,
                                )
                              ],
                            ).padding(
                                padding: const EdgeInsets.only(
                                    left: 23.0, right: 23.0, top: 8.0, bottom: 25.0)),
                            SizedBox(
                              height: 140,
                              child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount: tuesday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    // mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          tuesday[index]['order'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                        ).padding(
                                            padding:
                                                const EdgeInsets.only(left: 0)),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        height: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            tuesday[index]['subject'].toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          tuesday[index]['edu_class']
                                              .toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 15,
                                        ),
                                      ),
                                    ],
                                  ).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 22));
                                },
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.only(
                          left: 23.0, right: 23.0, top: 15),
                      child: Container(
                        width: 361,
                        height: 210,
                        decoration: BoxDecoration(
                          gradient: const LinearGradient(
                              begin: Alignment.centerRight,
                              end: Alignment.topRight,
                              colors: [
                                Color.fromRGBO(232, 211, 211, 1),
                                Color.fromRGBO(217, 217, 217, 1)
                              ]),
                          borderRadius: BorderRadius.circular(13.0),
                        ),
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                HeadTitleText(
                                  wednesday[0]['day'].toUpperCase(),
                                  fontFamily: 'alatsi',
                                  color: AppColors.newPrimeColor,
                                  size: 20,
                                ), //.padding(padding: const EdgeInsets.only(top: 8)),
                                HeadTitleText(
                                  wednesday[0]['date'],
                                  fontFamily: AppFonts.alatsi,
                                  color: Colors.black,
                                  size: 18,
                                )
                              ],
                            ).padding(
                                padding: const EdgeInsets.only(
                                    left: 23.0, right: 23.0, top: 8.0, bottom: 25.0)),
                            SizedBox(
                              height: 140,
                              child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount:
                                    wednesday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    // mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          wednesday[index]['order'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                        ).padding(
                                            padding:
                                                const EdgeInsets.only(left: 0)),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        height: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            wednesday[index]['subject']
                                                .toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            wednesday[index]['edu_class']
                                                .toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 15,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 22));
                                },
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.only(
                          left: 23.0, right: 23.0, top: 15),
                      child: Container(
                        width: 361,
                        height: 210,
                        decoration: BoxDecoration(
                          gradient: const LinearGradient(
                              begin: Alignment.centerRight,
                              end: Alignment.topRight,
                              colors: [
                                Color.fromRGBO(232, 211, 211, 1),
                                Color.fromRGBO(217, 217, 217, 1)
                              ]),
                          borderRadius: BorderRadius.circular(13.0),
                        ),
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                HeadTitleText(
                                  thursday[0]['day'].toUpperCase(),
                                  fontFamily: 'alatsi',
                                  color: AppColors.newPrimeColor,
                                  size: 20,
                                ), //.padding(padding: const EdgeInsets.only(top: 8)),
                                HeadTitleText(
                                  thursday[0]['date'],
                                  fontFamily: AppFonts.alatsi,
                                  color: Colors.black,
                                  size: 18,
                                )
                              ],
                            ).padding(
                                padding: const EdgeInsets.only(
                                    left: 23.0, right: 23.0, top: 8.0, bottom: 25.0)),
                            SizedBox(
                              height: 140,
                              child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount:
                                    thursday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    // mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: HeadTitleText(
                                          thursday[index]['order'].toString(),
                                          fontFamily: AppFonts.alatsi,
                                        ).padding(
                                            padding:
                                                const EdgeInsets.only(left: 0)),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        height: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            thursday[index]['subject'].toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: 50,
                                        child: Center(
                                          child: HeadTitleText(
                                            thursday[index]['edu_class']
                                                .toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 15,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 22));
                                },
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
                  ],
                ), //.padding(padding: const EdgeInsets.only(left: 17)),
              ),
            ),
          );
  }

  _getWeekData() async {
    print('1 weekly');
    print(baseUrl);
    http.Response res = await Api().getData('api/teacher/my-subject-table');
    print('2 weekly');
    var body = json.decode(res.body);
    print('hellllooooooo here from weekly screen');
    setState(() {
      data = body['data'];
      day = data;
      sunday = day['sunday'];
      monday = day['monday'];
      tuesday = day['tuesday'];
      wednesday = day['wednesday'];
      thursday = day['thursday'];
    });
    print('3 weekly');
    print('hellllooooooo here from var weekly day 0000000000000000000');
    print(data);
    print('4 weekly');
  }
}
