import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/models/child_model.dart';
import '../../../../../../common/widgets/dropdown.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';

class ChooseUser extends StatelessWidget {
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  final NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();

   ChooseUser({super.key});

  @override
  Widget build(BuildContext context) {
    authController.fillChildrenFromStorage();
    return Container(
      width: Get.width * .35,
      height: Get.height * 0.05,//45,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          // border: Border.all(color: Colors.red)
      ),
      child: DropDownWidget<ChildModel>(
        padding: const EdgeInsets.only(bottom: 0),
        margin: const EdgeInsets.only(bottom: 0),
        item: authController.childrens,
        toStr: (child) => child.name,
        compareFunction: (p0, p1) {
          return p0.compare(p1);
        },
        onChanged: (value) async {
          homeController.selectedChild.value = authController.childrens.indexOf(value);
          await homeController.saveSelectedChild(homeController.selectedChild.value);
          homeController.getNotification();
          newWeeklyController.getSubjectTable(authController.childrens[homeController.selectedChild.value].id);
          homeController.getNotes(
            {
              'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
              'from_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
              'to_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
            },
          );
          homeController.getLatestMeal(authController
              .childrens[homeController.selectedChild.value].id);
          homeController.getLatestResult({
            'registration_record_id': authController
                .childrens[homeController.selectedChild.value].id
          });
        },
        selectItem:
        authController.childrens[homeController.selectedChild.value],
      ),
    );
  }
}