import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:get/get.dart';
import '../../../../../../common/widgets/text.dart';

class HomeButton extends StatelessWidget {
  String icon;
  Color backGroundColor;
  String title;
  VoidCallback onTap;

  HomeButton({
    super.key,
    required this.icon,
    required this.backGroundColor,
    required this.title,
    required this.onTap
  });

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap:onTap ,
      child: Container(
        width: Get.width * 0.42,
        height: 85,
        decoration: BoxDecoration(
          color: backGroundColor,
          borderRadius: BorderRadius.circular(10),
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            InkWell(
              child: SvgPicture.asset(
                'asset/icons/$icon',
                color: Colors.white,
              ),
            ),
            TextTitle(
               title,
              textColor: Colors.white,
            )
          ],
        ),
      ),
    );
  }
}
