import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../features/notes/data/model/note.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class NoteObjectWidget extends StatelessWidget {
  final NoteResponse noteResponse;
  const NoteObjectWidget({super.key, required this.noteResponse});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 38,
      child: Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
        SizedBox(
          width: Get.width * 0.4,
          child: Text(
            noteResponse.title,
            maxLines: 1,
            overflow: TextOverflow.ellipsis,
            style: TextStyle(
                color: AppColors.appBlack.withOpacity(0.5),
                fontWeight: FontWeight.w400),
          ).padding(padding: const EdgeInsets.only(left: 10, right: 10)),
        ),
        NormalText(
          noteResponse.date,
          textColor: AppColors.secondaryColor.withOpacity(0.5),
        ),
        // NormalText(
        //   notificationModel.date.toString(),
        //   textColor: AppColors.appBlack.withOpacity(0.5),
        // ).padding(padding: const EdgeInsets.only(right: 10))
      ]),
    );
  }
}
