import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../business_logic/home_controller.dart';
import 'notification_object_home.dart';

class NotificationBody extends StatefulWidget {

  const NotificationBody({super.key});

  @override
  State<NotificationBody> createState() => _NotificationBodyState();
}

class _NotificationBodyState extends State<NotificationBody> {
  HomeController homeController = Get.put(HomeController());

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        NotificationObject(
          notificationModel: homeController.state.result[0],
        ).paddingSymmetric(horizontal: Get.width * .03),
        Divider(
            indent: 20,
            endIndent: 20,
            thickness: 0.8,
            color: AppColors.newSecondaryColor),
        homeController.state.result.length > 1
            ? NotificationObject(
                notificationModel: homeController.state.result[1],
              ).paddingSymmetric(horizontal: Get.width * .03)
            : Container()
      ],
    );
  }
}
