import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';
import '../../../notification/data/model/notification.dart';

class NotificationObject extends StatelessWidget {
  final NotificationResponse notificationModel;
  const NotificationObject({super.key, required this.notificationModel});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: Get.height * .08,//60,
      child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            SizedBox(
              height: Get.height * 0.7,
              width: Get.width * 0.6,
              child: Text(
                notificationModel.title,
                maxLines: 3,
                overflow: TextOverflow.ellipsis,
                style: TextStyle(
                    color: AppColors.appBlack.withOpacity(0.5),
                    fontWeight: FontWeight.w400),
              ).padding(padding: EdgeInsets.only(left: Get.width * .02, right: Get.width * .02)),
              ),
            NormalText(
              '${notificationModel.date.day}-${notificationModel.date.month}-${notificationModel.date.year}',
              textColor: AppColors.newPrimeColor.withOpacity(0.5),
            ),
        // NormalText(
        //   notificationModel.date.toString(),
        //   textColor: AppColors.appBlack.withOpacity(0.5),
        // ).padding(padding: const EdgeInsets.only(right: 10))
      ]),
    );
  }
}