import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/text.dart';

class SubjectContainer extends StatelessWidget {
  final String subjectName;
  const SubjectContainer({super.key, required this.subjectName});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10),
      alignment: Alignment.center,
      width: 80,
      height: 20,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(30),
          color: Colors.white,
          border: Border.all(color: AppColors.secondaryColor)),
      child: NormalText(
        subjectName.tr,
        textColor: AppColors.secondaryColor,
      ),
    );
  }
}
