import 'package:intl/intl.dart';

class LmsResponse {

  LmsResponse({
    required this.id,
    required this.name,
    required this.user,
    required this.repeatNumber,
    required this.date,
    this.body
});

  String id;
  String name;
  String user;
  String? body;
  int repeatNumber;
  DateTime date;


  factory LmsResponse.fromJson(Map<String, dynamic> json) =>
      LmsResponse(
        id: json["id"].toString(),
        name: json["name"],
        body: json['body'] ?? '',
        user: json['user'],
        repeatNumber: json['repeat_number'],
        date: convertToDateTime(json["activate_date"]),
      );

  factory LmsResponse.zero() => LmsResponse(
    id: '',
    name: '',
    repeatNumber: 0,
    user: '',
    date: DateTime.now(),
  );

  static List<LmsResponse> fromJsonList(
     Map<String, dynamic> json,
      String key,
      ) {
    List<LmsResponse> quiz = [];
    try{
      if (json[key] == null) {
        return [];
      }
      json[key].forEach(
            (q) => quiz.add(
          LmsResponse.fromJson(q),
        ),
      );
    } catch (e) {
      print('Error from Lms Quiz Response Error from Lms Quiz Response Error from Lms Quiz Response');
      print(e);
    }

    return quiz;
  }


  static DateTime convertToDateTime(String date) {
    DateFormat dateFormat = DateFormat('yyyy-MM-dd');
    DateTime s = dateFormat.parse(date);

    return s;
  }

}