import '../../../../../features/lms/data/model/answerModel.dart';

class QuestionModel {
  QuestionModel(
      {required this.id,
      required this.name,
      required this.mark,
      required this.time,
      required this.answers,
      this.body});

  String id;
  String name;
  int mark;
  int time;
  List<AnswerModel> answers;
  String? body;

  factory QuestionModel.zero() =>
      QuestionModel(id: '', name: '', mark: 0, time: 0, answers: []);

  factory QuestionModel.fromJson(Map<String, dynamic> json) => QuestionModel(
      id: json["id"].toString(),
      name: json["name"],
      mark: json["mark"],
      time: json["time"],
      answers: fromJsonList(json, "answers"));

  static List<AnswerModel> fromJsonList(Map<String, dynamic> json, String key) {
    List<AnswerModel> answers = [];
    try {
      if (json[key] == null) {
        return [];
      }
      json[key].forEach((a) => answers.add(AnswerModel.fromJson(a)));
    } catch (e) {
      print(
          'Error from Question Model Error from Question Model Error from Question Model');
      print(e);
    }

    return answers;
  }
}
