import '../../../../../common/constant/apis.dart';
import '../../../../../core/network/http.dart';
import '../../../../../features/lms/data/model/quizModel.dart';
import '../../../../../features/lms/data/model/reportDetailResponse.dart';
import '../../../../../features/lms/data/model/studentQuizModel.dart';
import '../../../../../features/purchase/api_res.dart';



class QuizService {


  Future<QuizModel> getQuizInfo(String quizId) async {
    Request request = Request(
        '${EndPoints.getQuizInfo}/$quizId',
        RequestMethod.get,
        authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return QuizModel.fromJson(response['data']);
  }


  sendQuizData({required List<Map<String, dynamic>> body, required String quizId}) async{
    try{
      Request request = Request(
        EndPoints.sendQuizInfo(),
        RequestMethod.post,
        body: {
          "quiz_id" : quizId,
          "answers" : body
        },
        authorized: true
      );
      Map<String, dynamic> response = await request.sendRequest();
      return ApiResponse(data: response['data']);
    }catch (e){
      print('*********************** This error is from QUIZ SERVICE CLASS ***********************');
      print(e);
    }
  }


  Future<StudentQuizModel> getDetailReport(var studentQuizId) async{
    Request request = Request(
      '${EndPoints.getQuizDetailReport}/$studentQuizId',
      RequestMethod.get,
      authorized: true
    );
    Map<String, dynamic> response = await request.sendRequest();
    List<ReportDetailResponse> list = ReportDetailResponse.fromJsonList(response,'data');
    return StudentQuizModel (
        id: response['student_quiz']['id'] ,
        result: response['student_quiz']['result'],
        quizResult: response['student_quiz']['quiz_result'],
        list: list
    );
  }

}
