import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/rx_view.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/lms/business_logic/lms_controller.dart';
import '../../../../../features/lms/business_logic/quizController.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';

class CompletedQuiz extends StatefulWidget {
  const CompletedQuiz(this.subjectId, this.regsId,{super.key});

  final String subjectId;
  final String regsId;

  @override
  State<CompletedQuiz> createState() => _CompletedQuizState();
}

class _CompletedQuizState extends State<CompletedQuiz> {


  LmsController lmsController = Get.find<LmsController>();
  QuizController quizController = Get.find<QuizController>();

 loadData() async{
    await lmsController.getLmsCompleted(widget.subjectId,widget.regsId);

  }

  @override
  void initState() {
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.all(Get.width *0.02),
      child: Obx(() {
        return lmsController.lmsCompletedState.loading ? const CircularProgressIndicatorWidget() : lmsController.lmsCompletedState.result.isEmpty
        ? HeadTitleText(
                    'no quiz completed'.toUpperCase(),
                    color: AppColors.newPrimeColor,
                    size: 30,
                    fontFamily: AppFonts.alatsi,
                  ).center() : GridView.count(
                    childAspectRatio: 450/500,//Get.width * 0.45 / Get.height * 6,
                    crossAxisCount: 2,
                    shrinkWrap: true,
                    children: List.generate(lmsController.lmsCompletedState.result.length, (index) {
        return Padding(
          padding: const EdgeInsets.all(8.0),
          child: GestureDetector(
            onTap: () async{
              print(lmsController.lmsCompletedState.result[index].id);
              await quizController.getQuizReport(lmsController.lmsCompletedState.result[index].id);
              RoutingManager.to(
                'lmsSummary',
                arguments: lmsController.lmsCompletedState.result[index].id.toString(),
              );
            },
            child: Container(
              decoration: BoxDecoration(
                  color:  AppColors.quizItem,
                  borderRadius: BorderRadius.circular(20),
                  boxShadow: [
                    BoxShadow(
                      color: AppColors.quizShadow,
                      blurRadius: 1,
                    )
                  ]
              ),
              child: Padding(
                padding: const EdgeInsets.only(top: 8.0),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  children: [
                    AutoSizeText(
                        lmsController.lmsCompletedState.result[index].quiz,
                      style: TextStyle(
                        fontSize: 20,
                          color: AppColors.newPrimeColor
                      ),
                      maxLines: 2,
                    ),
                    // HeadTitleText(
                    //   'Quiz Information & Communication Technology',//${lmsController.lmsCompletedState.result[index].resultPercent.round().toString()} ',
                    //   size: 20,
                    //   color: AppColors.newPrimeColor,
                    //   fontFamily: AppFonts.alatsi,
                    // ),
                    HeadTitleText(
                      DateFormat('d MMM y').format(lmsController.lmsCompletedState.result[index].date),
                      size: 20,
                      fontFamily: AppFonts.alatsi,
                    ),
                    HeadTitleText(
                      lmsController.lmsCompletedState.result[index].attemptNum.toString(),
                      color: AppColors.newPrimeColor,
                      size: 15,
                      fontFamily: AppFonts.alatsi,
                    ),
                    CircleAvatar(
                      radius: 45,
                      backgroundColor: AppColors.newPrimeColor,
                      child: Container(
                        width: 75,
                        height: 75,
                        decoration: const BoxDecoration(
                          color: Colors.white,
                          shape: BoxShape.circle,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.black,
                              spreadRadius: 0,
                              blurRadius: 5,
                            ),
                          ],
                        ),
                        child: Center(
                          child: SizedBox(
                            // color: Colors.greenAccent,
                            width: Get.width * 0.17,
                            height: Get.width * 0.17,//68,
                            child: Center(
                              child: Padding(
                                padding: const EdgeInsets.all(2.0),
                                child: Stack(
                                  fit: StackFit.expand,
                                  children: [
                                    CircularProgressIndicator(
                                      value: lmsController.lmsCompletedState.result[index].resultPercent / 100,
                                      color: AppColors.newPrimeColor,
                                      strokeWidth: 1,
                                    ),
                                    Center(
                                      child:
                                      AutoSizeText(
                                                      lmsController.lmsCompletedState.result[index].result,
                                                      style: TextStyle(
                                                          color: Colors.black,
                                                          // fontSize: 20,
                                                          fontFamily:
                                                              AppFonts.alatsi),
                                                      maxLines: 2,
                                                      maxFontSize: 20,
                                                      minFontSize: 5,
                                                    ), 
                                      // HeadTitleText(
                                      //     lmsController.lmsCompletedState.result[index].result,
                                      //     color: Colors.black,
                                      //     size: 20,
                                      //     fontFamily: AppFonts.alatsi
                                      // ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                        )
                      ),
                    ),
        
                    // const Image(image: AssetImage('asset/images/ToDoQuiz.png')),
                  ],
                ),
              )//.padding(padding: EdgeInsets.symmetric(vertical: Get.height * 0.03)),
            ),
          ),
        );
                    }),
                  );
    
      }
         ),
    );
  }
}
