import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../features/calender/business_logic/calender_controller.dart';
import '../../../../../features/calender/data/models/subject_response.dart';
import '../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../features/lms/business_logic/lms_controller.dart';
import '../../../../../features/lms/presentation/widgets/lms_body.dart';


class LmsIndexPage extends StatefulWidget {

  const LmsIndexPage({super.key});


  @override
  State<LmsIndexPage> createState() => _LmsIndexPageState();
}

class _LmsIndexPageState extends State<LmsIndexPage> {

  LmsController lmsController = Get.find<LmsController>();

  CalenderController calenderController = Get.find<CalenderController>();

  AuthController authController = Get.find<AuthController>();

  HomeController homeController = Get.find<HomeController>();

  loadData() async{
    await lmsController.getSubjects(authController.childrens[homeController.selectedChild.value].id);
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }


  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Get.offAllNamed(RoutesName.homePage);
            },
          ),
          title: Center(
            child: HeadTitleText(
              'LMS'.toUpperCase(),
              color: AppColors.newPrimeColor,
              fontFamily: 'alatsi',
              size: 20,
            ).padding(padding: const EdgeInsets.only(right: 50, bottom: 10)),
          ),
        ),
        body: SingleChildScrollView(
          child: Column(
            children: [
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 0),
                child: SizedBox(
                    height: Get.height,
                    width: Get.width,
                    child: Obx(() {
                      return lmsController.subjectState.loading
                          ?   CircularProgressIndicator(
                        color: AppColors.newPrimeColor,
                      ).center()
                          : SizedBox(
                        width: Get.width,
                        child: ListView.separated(
                          itemCount: lmsController.subjectState.result.length,//calenderController.subjectState.result.length,
                          itemBuilder: (BuildContext context, index) {
                            SubjectResponse lms = lmsController.subjectState.result[index];
                            return LmsBodyWidget(
                              Lms: lms).onTap(() async{
                                await lmsController.getLmsQuiz(lms.id,authController.childrens[homeController.selectedChild.value].id);
                                RoutingManager.to(
                                  RoutesName.lmsQuiz,
                                  arguments: [lms.id,lms.name],
                                );
                            });
                          },
                          separatorBuilder: (BuildContext context, index) {
                            return const Divider(
                              color: Colors.transparent,
                              height: 0,
                              thickness: 0,
                            );
                          },
                        ),
                      );
                    })),
              )
            ],
          ),
        ),
      ),
    );
  }
}


/*
return
                        RxView(
                          rxFuture: lmsController.subjectState,
                          onRetry: () {
                            lmsController.getSubjects(reg);
                          },
                          child:
                          // lmsController.subjectState.loading
                          //     ? CircularProgressIndicator(
                          //   color: AppColors.newPrimeColor,
                          // )
                          //     :
                          ListView.separated(
                              itemCount: lmsController.subjectState.result.length,//calenderController.subjectState.result.length,
                              itemBuilder: (BuildContext context, index) {
                                // SubjectResponse note = calenderController
                                //     .subjectState.result[index];
                                SubjectResponse lms = lmsController.subjectState.result[index];
                                return LmsBodyWidget(
                                  Lms: lms,
                                )//;
                                .onTap(() {
                                  // RoutingManager.to(
                                  //   RoutesName.lmsSummary
                                  // );
                                  RoutingManager.to(
                                    RoutesName.lmsQuiz,
                                    arguments: [lms.id,lms.name],
                                  );
                                });
                              },
                              separatorBuilder: (BuildContext context, index) {
                                return const Divider(
                                  color: Colors.transparent,
                                  height: 0,
                                  thickness: 0,
                                );
                              },
                          )
                      );
 */
