import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../features/lms/business_logic/lms_controller.dart';
import '../../../../../features/lms/presentation/screens/completedQuiz.dart';
import '../../../../../features/lms/presentation/screens/toDoQuiz.dart';

class LmsQuiz extends StatefulWidget {
  const LmsQuiz({super.key});

  @override
  State<LmsQuiz> createState() => _LmsQuizState();
}

class _LmsQuizState extends State<LmsQuiz> {
  AuthController authController = Get.find<AuthController>();

  final LmsController lmsController = Get.find<LmsController>();
  HomeController homeController = Get.find<HomeController>();


  List<String> data = [];
  // String? id;

  loadData() async{
    data = Get.arguments;
    await lmsController.getLmsQuiz(data[0],authController.childrens[homeController.selectedChild.value].id);
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    print('123465789 123456789 132456789');
    print(lmsController.lmsState.subject.length);
    return Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: SizedBox(
            width: Get.width * 1,
            child: AutoSizeText(
              data[1],
              style: TextStyle(
                  fontSize: 20,
                  fontFamily: AppFonts.alatsi,
                color: AppColors.newPrimeColor
              ),
              maxLines: 1,
            ).padding(padding: EdgeInsets.only(left: Get.width * 0.10, right: Get.width * 0.15,bottom: Get.height * 0.01)),
          ),
        ),

        body: DefaultTabController(
          initialIndex: 1,
          length: 3,
          child: TabBarView(
            children: [
              SubTabBar(data[0]),
            ],
          ),
        ),
      ),
    );
  }
}



class SubTabBar extends StatefulWidget {
  const SubTabBar(this.subjectId, {super.key});

  final String subjectId;

  @override
  State<SubTabBar> createState() => _SubTabBarState();
}

class _SubTabBarState extends State<SubTabBar> with TickerProviderStateMixin{

  late final TabController _tabController;

  final LmsController lmsController = Get.find<LmsController>();

  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();

  var regsId;

  @override
  void initState() {
    regsId = authController.childrens[homeController.selectedChild.value].id;
    super.initState();
    _tabController = TabController(length: 2, vsync: this);
    lmsController.getLmsQuiz(widget.subjectId,regsId);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Padding(
          padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * 0.05 ,vertical: MediaQuery.of(context).size.width * 0.02 ),
          child: Container(
            height: MediaQuery.of(context).size.height * 0.035,
            decoration: BoxDecoration(
                color: AppColors.newSecondaryColor,
                borderRadius: BorderRadius.circular(20)
            ),
            child: TabBar.secondary(
              labelColor: Colors.white,
              unselectedLabelColor: AppColors.newPrimeColor,
              indicator: BoxDecoration(
                  color: AppColors.newPrimeColor,
                  borderRadius: BorderRadius.circular(20)
              ),
              controller: _tabController,
              tabs: <Widget>[
                Tab(
                    child: HeadTitleText(
                      "To Do".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),
                Tab(
                    child: HeadTitleText(
                      "Completed".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),

              ],
            ),
          ),
        ),
        Expanded(
          child: TabBarView(
            controller: _tabController,
            children: <Widget>[
              ToDoQuiz(widget.subjectId,regsId),
              CompletedQuiz(widget.subjectId,regsId),
            ],
          ),
        )
      ],
    );
  }
}
