
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/widgets/rx_view.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/lms/business_logic/quizController.dart';

import '../../../../common/widgets/text.dart';

class LmsSplashQuiz extends StatefulWidget {
  const LmsSplashQuiz({super.key});

  @override
  State<LmsSplashQuiz> createState() => _LmsSplashQuizState();
}

class _LmsSplashQuizState extends State<LmsSplashQuiz> {

  QuizController quizController = Get.find<QuizController>();

  int? repeatNum;
  int? attemptNum;

  bool selected = false;

  loadData() async {
    await quizController.getQuizInfo(Get.arguments);
  }

  
  String? quizId;
  
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    quizController.getQuizInfo(Get.arguments);
    quizId = Get.arguments;
    return Scaffold(
        backgroundColor:
            const Color.fromRGBO(194, 194, 194, 1), //rgba(194, 194, 194, 1),
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
              onPressed: () {
                Get.back();
              },
              icon: Icon(
                size: 30,
                Icons.arrow_back,
                color: AppColors.newPrimeColor,
              )),
        ),
        body: Padding(
          padding: EdgeInsets.only(
              left: Get.width * 0.05,
              right: Get.width * 0.05,
              top: Get.height * 0.0),
          child: SizedBox(
            width: Get.width,
            height: Get.height * 0.85,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Container(
                  // color: Colors.red,
                  width: Get.width * .4,
                  height: Get.height * .67,
                  child: AnimatedAlign(
                    alignment: selected ? Alignment.topCenter : Alignment.bottomLeft,
                    duration: const Duration(seconds: 1),
                    curve: Curves.fastOutSlowIn,
                    child: const Image(image: AssetImage('asset/images/lmsSplash.png')),
                  ),
                ),
                // Padding(
                //   padding: const EdgeInsets.symmetric(vertical: 0.0),
                //   child: Container(
                //     color: Colors.red,
                //     width: 141,
                //     height: 550,
                //     child:
                //         Image(image: AssetImage('asset/images/lmsSplash.png')),
                //   ),
                // ),
                SizedBox(
                  width: Get.width * 0.8,
                  child: Center(
                    child: HeadTitleText(
                      'Good luck to you and we wish you success in your quiz.',
                      size: 20,
                      fontFamily: AppFonts.alatsi,
                      color: AppColors.newPrimeColor,
                    ),
                  ),
                ),
                Obx(() {
                  repeatNum = quizController.quizState.result.repeatNumber;
                  attemptNum = quizController.quizState.result.attemptNumber;
                  return RxView(
                      rxFuture: quizController.quizState,
                      onRetry: () {
                        quizController.getQuizInfo(Get.arguments);
                      },
                      child: Padding(
                        padding: const EdgeInsets.symmetric(vertical: 20.0),
                        child: GestureDetector(
                          onTap:
                          (repeatNum == attemptNum && repeatNum != 0)
                              ? null
                              : () {
                            setState(() {
                              selected = !selected;
                            });
                            // quizController.animatedStart = true;
                            print('>>>>>>>>>>>>>>>>>> data Here <<<<<<<<<<<<<<<<<<');
                            print(quizController.quizState.result);
                            print('>>>>>>>>>>>>>>>>>> data Here <<<<<<<<<<<<<<<<<<');
                            Future.delayed(Duration(seconds: 1), (){
                              RoutingManager.to('lmsPage',);
                              RoutingManager.to('quizStart',arguments: [quizId,quizController.quizState.result]);
                            });
                          },
                          child: Container(
                            decoration: BoxDecoration(
                                color: (repeatNum == attemptNum && repeatNum != 0) ? AppColors.newPrimeColor.withOpacity(0.3) : AppColors.newPrimeColor ,
                                borderRadius: const BorderRadius.all(
                                  Radius.circular(20),
                                ),
                                border: Border.all(
                                    color: AppColors.newPrimeColor)),
                            height: MediaQuery.of(context).size.height * 0.06,
                            width: MediaQuery.of(context).size.width * 0.8,
                            child: Center(
                              child: HeadTitleText(
                                (attemptNum! == repeatNum! && repeatNum != 0)  ? '' : "let's go with ${quizController.quizState.result.name}".toUpperCase(),
                                size: 20,
                                color: Colors.white,
                                fontFamily: AppFonts.alatsi,
                              ),
                            ),
                          ),
                        ),
                      )
                  );
                }),
              ],
            ),
          ),
        ));
  }
}
