import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/lms/business_logic/quizController.dart';

class LmsSummary extends StatefulWidget {
  const LmsSummary({super.key});

  @override
  State<LmsSummary> createState() => _LmsSummaryState();
}

class _LmsSummaryState extends State<LmsSummary> {
  QuizController quizController = Get.find<QuizController>();

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)),
        child: Scaffold(
          backgroundColor: Colors.transparent,
          appBar: AppBar(
            backgroundColor: Colors.transparent,
            leading: IconButton(
                onPressed: () {
                  RoutingManager.off('home-page');
                },
                icon: Icon(
                  size: 30,
                  Icons.arrow_back,
                  color: AppColors.newPrimeColor,
                )),
          ),
          body: Stack(
            children: [
              Padding(
                padding: const EdgeInsets.only(top: 40.0),
                child: Container(
                  width: Get.width * 0.9, //361,
                  height: Get.height * 0.80, //650,
                  decoration: const BoxDecoration(
                      color: Color.fromRGBO(
                          217, 217, 217, 1), //rgba(217, 217, 217, 1)
                      borderRadius: BorderRadius.all(Radius.circular(20))),
                  child: Padding(
                      padding: EdgeInsets.only(top: Get.height * 0.1),
                      child: Column(
                        children: [
                          HeadTitleText(
                            'summary'.toUpperCase(),
                            size: 25,
                            color: Colors.black,
                            fontFamily: AppFonts.alatsi,
                          ),
                          Container(
                            color: Colors.transparent,
                            height: Get.height * 0.657,
                            width: 337,
                            child: Padding(
                              padding: const EdgeInsets.only(top: 0.0),
                              child: ListView.builder(
                                  itemCount: quizController
                                      .quizDetailState.result.list.length,
                                  itemBuilder: (BuildContext ctx, index) {
                                    return Obx(() {
                                      return Container(
                                        height: 161,
                                        color: Colors.transparent,
                                        child: Stack(
                                          children: [
                                            Positioned(
                                              // left: 25,
                                              top: 15,
                                              child: Container(
                                                width: MediaQuery.of(ctx)
                                                        .size
                                                        .width -
                                                    75,
                                                height: 141,
                                                decoration: BoxDecoration(
                                                    color: Colors.white,
                                                    // borderRadius: BorderRadius.circular(20)
                                                    border: Border.all(
                                                      color: quizController
                                                              .quizDetailState
                                                              .result
                                                              .list[index]
                                                              .isCorrect
                                                          ? AppColors
                                                              .correctAnswer
                                                          : AppColors
                                                              .wrongAnswer,
                                                    ),
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            20)),
                                                child: Column(
                                                  mainAxisAlignment: quizController.quizDetailState.result.list[index].isCorrect ? MainAxisAlignment.spaceAround : MainAxisAlignment.spaceBetween,
                                                  children: [
                                                    AutoSizeText(
                                                      quizController
                                                          .quizDetailState
                                                          .result
                                                          .list[index]
                                                          .question,
                                                      style: TextStyle(
                                                          color: Colors.black,
                                                          fontSize: 20,
                                                          fontFamily:
                                                              AppFonts.alatsi),
                                                      maxLines: 2,
                                                      maxFontSize: 20,
                                                      minFontSize: 10,
                                                    ),
                                                    quizController.quizDetailState.result.list[index].isCorrect
                                                        ? Row(
                                                        children: [
                                                          Icon(
                                                            Icons
                                                                .check_circle_outline_rounded,
                                                            color: AppColors
                                                                .correctAnswer,
                                                          ),
                                                          SizedBox(width: Get.width * 0.02,),
                                                          AutoSizeText(
                                                            quizController
                                                                .quizDetailState
                                                                .result
                                                                .list[index]
                                                                .correctAnswer,
                                                            style: TextStyle(
                                                                color: Colors
                                                                    .black,
                                                                fontSize: 20,
                                                                fontFamily: AppFonts
                                                                    .alatsi
                                                            ),
                                                            maxLines: 2,
                                                            maxFontSize: 20,
                                                            minFontSize: 10,
                                                          )
                                                        ]
                                                    )
                                                        :
                                                    Column(
                                                      children: [
                                                        Row(
                                                            children: [
                                                              Icon(
                                                                Icons
                                                                    .check_circle_outline_rounded,
                                                                color: AppColors
                                                                    .correctAnswer,
                                                              ),
                                                              SizedBox(width: Get.width * 0.02,),
                                                              AutoSizeText(
                                                                quizController
                                                                    .quizDetailState
                                                                    .result
                                                                    .list[index]
                                                                    .correctAnswer,
                                                                style: TextStyle(
                                                                    color: Colors
                                                                        .black,
                                                                    fontSize: 20,
                                                                    fontFamily: AppFonts
                                                                        .alatsi
                                                                ),
                                                                maxLines: 2,
                                                                maxFontSize: 20,
                                                                minFontSize: 10,
                                                              )
                                                            ]
                                                        ),
                                                        Row(
                                                          children: [
                                                            Icon(
                                                              Icons
                                                                  .cancel_outlined,
                                                              color: AppColors
                                                                  .wrongAnswer,
                                                            ),
                                                            SizedBox(width: Get.width * 0.02,),
                                                            AutoSizeText(
                                                              quizController
                                                                  .quizDetailState
                                                                  .result
                                                                  .list[index]
                                                                  .answer,
                                                              style: TextStyle(
                                                                  color: Colors
                                                                      .black,
                                                                  fontSize: 20,
                                                                  fontFamily:
                                                                      AppFonts
                                                                          .alatsi),
                                                              maxLines: 2,
                                                              maxFontSize: 20,
                                                              minFontSize: 10,
                                                            )
                                                          ],
                                                        )
                                                      ],
                                                    )
                                                  ],
                                                ).padding(
                                                    padding: EdgeInsets.only(
                                                        top: Get.width * 0.02,
                                                        bottom:
                                                            Get.width * 0.02,
                                                        left: Get.width * 0.02,
                                                        right:
                                                            Get.width * 0.02)),
                                              ),
                                            ),
                                            Positioned(
                                                left: 15,
                                                top: 0,
                                                child: Container(
                                                  width: 30,
                                                  height: 30,
                                                  decoration: BoxDecoration(
                                                      color: Colors.white,
                                                      shape: BoxShape.circle,
                                                      border: Border.all(
                                                          color: quizController
                                                                  .quizDetailState
                                                                  .result
                                                                  .list[index]
                                                                  .isCorrect
                                                              ? AppColors
                                                                  .correctAnswer
                                                              : AppColors
                                                                  .wrongAnswer)),
                                                  child: Center(
                                                    child: HeadTitleText(
                                                      '${index + 1}',
                                                      color: Colors.black,
                                                    ),
                                                  ),
                                                ))
                                          ],
                                        ),
                                      );
                                    });
                                  }),
                            ),
                          )
                        ],
                      )),
                ).center(),
              ),
              // the result
              Positioned(
                  left: Get.width * 0.3, //125,
                  right: Get.width * 0.3, //125,
                  top: 0,
                  child: SizedBox(
                      child: CircleAvatar(
                    radius: 75,
                    backgroundColor: AppColors.correctAnswer,
                    child: Container(
                        width: Get.width * 0.31, //130,
                        height: Get.width * 0.31, //130,
                        decoration: const BoxDecoration(
                          color: Colors.white,
                          shape: BoxShape.circle,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.black,
                              spreadRadius: 0,
                              blurRadius: 5,
                            ),
                          ],
                        ),
                        child: Center(
                          child: SizedBox(
                            width: Get.width * 0.28,
                            height: Get.width * 0.28, //68,
                            child: Center(
                              child: Padding(
                                padding: const EdgeInsets.all(2.0),
                                child: Stack(
                                  fit: StackFit.expand,
                                  children: [
                                    CircularProgressIndicator(
                                      value: quizController
                                              .quizDetailState.result.result /
                                          quizController.quizDetailState.result
                                              .quizResult,
                                      color: AppColors.correctAnswer,
                                      strokeWidth: 1.5,
                                    ),
                                    Center(
                                      child:
                                      AutoSizeText(
                                                      '${quizController.quizDetailState.result.result}/${quizController.quizDetailState.result.quizResult}',
                                                      style: TextStyle(
                                                          color: Colors.black,
                                                          // fontSize: 20,
                                                          fontFamily:
                                                              AppFonts.alatsi),
                                                      maxLines: 2,
                                                      maxFontSize: 35,
                                                      minFontSize: 25,
                                                    ), 
                                      //  HeadTitleText(
                                      //     '${quizController.quizDetailState.result.result}/${quizController.quizDetailState.result.quizResult}', //lmsController.lmsCompletedState.result[index].result,
                                      //     color: Colors.black,
                                      //     size: 35,
                                      //     fontFamily: AppFonts.alatsi),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                        )),
                  ) //.padding(padding: EdgeInsets.symmetric(vertical: Get.height * 0.03)),
                      )),
            ],
          ),
        ));
  }
}

/*
Stack(
          children: [
            Positioned(
                left: Get.width * 0.3,//125,
                right: Get.width * 0.3,//125,
                top: 0,
                child: Obx(() {
                  return SizedBox(
                      child: CircleAvatar(
                        radius: 75,
                        backgroundColor: AppColors.correctAnswer,
                        child: Container(
                            width: Get.width * 0.31,//130,
                            height: Get.width * 0.31,//130,
                            decoration: const BoxDecoration(
                              color: Colors.white,
                              shape: BoxShape.circle,
                              boxShadow: [
                                BoxShadow(
                                  color: Colors.black,
                                  spreadRadius: 0,
                                  blurRadius: 5,
                                ),
                              ],
                            ),
                            child: Center(
                              child: SizedBox(
                                width: Get.width * 0.28,
                                height: Get.width * 0.28,//68,
                                child: Center(
                                  child: Padding(
                                    padding: const EdgeInsets.all(2.0),
                                    child: Stack(
                                      fit: StackFit.expand,
                                      children: [
                                        CircularProgressIndicator(
                                          value: quizController.quizDetailState.result.result / quizController.quizDetailState.result.quizResult,
                                          color: AppColors.correctAnswer,
                                          strokeWidth: 1.5,
                                        ),
                                        Center(
                                          child: HeadTitleText(
                                              '${quizController.quizDetailState.result.result}/${quizController.quizDetailState.result.quizResult}',//lmsController.lmsCompletedState.result[index].result,
                                              color: Colors.black,
                                              size: 35,
                                              fontFamily: AppFonts.alatsi
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            )
                        ),
                      )//.padding(padding: EdgeInsets.symmetric(vertical: Get.height * 0.03)),
                  );
                })
            ),
            Padding(
              padding: const EdgeInsets.only(top: 40.0),
              child: Container(
                width: Get.width * 0.9,//361,
                height: Get.height * 0.80,//650,
                decoration: const BoxDecoration(
                    color: Color.fromRGBO(217, 217, 217, 1), //rgba(217, 217, 217, 1)
                    borderRadius: BorderRadius.all(Radius.circular(20))
                ),
                child: Padding(
                    padding: EdgeInsets.only(top: Get.height*0.1),
                    child: Column(
                      children: [
                        HeadTitleText(
                          'summary'.toUpperCase(),
                          size: 25,
                          color: Colors.black,
                          fontFamily: AppFonts.alatsi,
                        ),
                        Text('data'),
                        ListView.builder(itemBuilder: (BuildContext ctx , index){
                          return Container(
                            height: 25,
                            width: 25,
                            color: Colors.red,
                          );
                        })

                      ],
                    )

                ),
              ).center(),
            ),
            // the result

          ],
        )
 */

// محاولة ثانية
/*

Stack(
                            children: [
                              Padding(
                                padding: const EdgeInsets.only(top: 15.0),
                                child: ListView.builder(
                                    itemCount: quizController.quizDetailState.result.list.length,
                                    itemBuilder: (BuildContext ctx , index){
                                      return Column(
                                        children: [
                                          Container(
                                            height: 141,
                                            decoration: BoxDecoration(
                                                color: Colors.white,
                                                borderRadius: BorderRadius.circular(20)
                                            ),
                                          ),
                                          SizedBox(height: 10,)
                                        ],
                                      );
                                    }),
                              ),
                          Positioned(
                            left: 15,
                            child: Container(
                              width: 30,
                              height: 30,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                shape: BoxShape.circle,
                                border: Border.all(color: AppColors.correctAnswer)
                              ),
                              child: Center(
                                child: HeadTitleText(
                                  '1',
                                  color: Colors.black,
                                ),
                              ),
                            ))
                            ],
                          )
 */
