import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../features/calender/data/models/subject_response.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class LmsBodyWidget extends StatelessWidget {
  final SubjectResponse Lms;

  const LmsBodyWidget({
    super.key,
    required this.Lms,
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 25.0, vertical: 10),
      child: Container(
        height: 75,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(20),
          gradient: const LinearGradient(
                  begin: Alignment.centerRight,
                  end: Alignment.topRight,
                  colors: [
                    Color.fromRGBO(232, 211, 211, 1),
                    Color.fromRGBO(217, 217, 217, 1),
                  ]
          )
        ),
        child: Row(
          children: [
            SizedBox(
              width: Get.width * 0.1,
              height: 35,
              child: const Image(
                image: AssetImage('asset/images/homeWork.png'),
                fit: BoxFit.contain,),
            ),
            SizedBox(width: Get.width * 0.02,),
            SizedBox(
              width: Get.width * 0.5,
              child: HeadTitleText(
                Lms.name.tr,
                color: AppColors.newPrimeColor,
                fontFamily: AppFonts.alatsi,
              ),
            ),
            SizedBox(
              width: Get.width * 0.14,
            ),
            HeadTitleText(
              Lms.quizNumber.toString(),//'1',
              color: AppColors.newPrimeColor,
              size: 15,
              fontFamily: AppFonts.alatsi,
            )
          ],
        ).padding(padding: EdgeInsets.symmetric(horizontal: Get.width * 0.025)),
      ),
    );
      Container(
      margin: const EdgeInsets.only(bottom: 40 ,),
      width: Get.width * .85,
      height: 150,
      decoration: BoxDecoration(
          border: Border.all(color: AppColors.primeColor),
          borderRadius: BorderRadius.circular(10)),
      child: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 10),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                TextTitle(
                  Lms.name.tr,
                  textColor: AppColors.secondaryColor,
                ).expanded(6),

                SvgPicture.asset(
                  'asset/icons/Info Circle.svg',
                  color: AppColors.primeColor,
                ).expanded(1)
              ],
            ),

          ],
        ),
      ),
    );
  }
}
