class NewWeeklyPurchaseModel{

  String? status;
  Map<String,NewPurchaseDaily> weeklyPurchases;

  NewWeeklyPurchaseModel({
    this.status,
    required this.weeklyPurchases,
  });

  factory NewWeeklyPurchaseModel.zero() => NewWeeklyPurchaseModel(
      status: '', weeklyPurchases: {});


  factory NewWeeklyPurchaseModel.fromJson(Map<String, dynamic> json) {
    // print("first Step of error");
    List<String> days = ['Sunday','Monday','Tuesday','Wednesday','Thursday'];
    Map<String,NewPurchaseDaily> purchases = {};
    // print('222222');
    days.forEach((element) {
      // print(json['data']);
      purchases[element] = NewPurchaseDaily(date: json['data'][element]['date'],weeklyPurchases:  NewPurchaseModel.fromJsonList(json['data'][element]["value"]));
    });
    return NewWeeklyPurchaseModel(status: json['status'], weeklyPurchases: purchases);
  }


  NewPurchaseDaily getNewPurchase(String day){
    NewPurchaseDaily? newPurchaseDaily = weeklyPurchases[day];
    // print('*-*-*-*-*-*-*-* from get new Purchase class *-*-*-*-*-*-*-*');
    print(newPurchaseDaily!.weeklyPurchases);
    // print(newPurchaseModel.id);
    // print(newPurchaseModel.studentName);
    // print(newPurchaseModel.mealName);
    // print(newPurchaseModel.quantity);
    // print(newPurchaseModel.price);
    // print(newPurchaseModel.date);
    // print(newPurchaseModel.group);
    // print('*-*-*-*-*-*-*-* from get new Purchase class *-*-*-*-*-*-*-*');
    return newPurchaseDaily;
  }
}

class NewPurchaseDaily {

  String date;
  List<NewPurchaseModel> weeklyPurchases;

  NewPurchaseDaily({
    required this.date,
    required this.weeklyPurchases
  });

  factory NewPurchaseDaily.zero() => NewPurchaseDaily(date: '', weeklyPurchases: []);

}

class NewPurchaseModel {

  String id;
  String date;
  String studentName;
  String mealName;
  String group;
  String quantity;
  String coin;
  int price;

  NewPurchaseModel({
    required this.id,
    required this.date,
    required this.studentName,
    required this.mealName,
    required this.group,
    required this.quantity,
    required this.coin,
    required this.price,
  });

  factory NewPurchaseModel.zero() => NewPurchaseModel(
      id: '', date: '', studentName: '', mealName: '', group: '', quantity: '', coin: '', price: 0);

  factory NewPurchaseModel.fromJson(Map<String, dynamic> json) => NewPurchaseModel(
      id: json['id'].toString() ,
      date: json['data'].toString(),
      group: json['group'] ?? '',
      studentName: json['student_name'],
      mealName: json['meal_name'],
      price: json['total'] ?? 0,
      coin: json['coin'] ?? '',
      quantity: json['quantity'].toString()
  );

  static List<NewPurchaseModel> fromJsonList(List<dynamic> data) {
    List<NewPurchaseModel> purchases = [];
    for (var element in data) {
      try {
        NewPurchaseModel p = NewPurchaseModel.fromJson(element);
        purchases.add(p);
      } catch (e) {
        print(
            'Error from New Purchase Model Error from New Purchase Model Error from Variable Model');
        print(e);
      }
    }

    return purchases;
  }
}

