import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/notes/data/model/note.dart';
import '../../../../../../features/notes/data/service/note_service.dart';

class NoteController extends GetxController {
  //get all notes no filtering***************

  RxFuture<List<NoteResponse>> notesState = RxFuture([]);

  NoteService noteService = NoteService();

  Future<void> getNotes(Map<String, dynamic> params) async {
       Future.delayed(
      Duration(seconds: 1),
      ()async{
    await notesState.observe(
      (_) async {
        return await noteService.getNotes(params);
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
    }
    );
  }

  RxFuture<NoteResponse> singleNoteState = RxFuture(NoteResponse.zero());
  Future<void> getSingleNote(String id) async {
    await singleNoteState.observe((_) async {
      return await noteService.getSingleNote(id);
    });
  }

  NoteResponse getNoteResponseFromStateById(String id) {
    return singleNoteState.result;
  }
}
