
import 'package:intl/intl.dart';
import '../../../../../../features/calender/data/models/attachment.dart';


class NoteResponse {
  NoteResponse({
    required this.id,
    required this.title,
    required this.note,
    required this.name,
    required this.type,
    required this.date,
    required this.read,
    required this.registrationRecordId,
    required this.useName,
    required this.attachment,
  });

  String id;
  String title;
  String note;
  String name;
  String type;
  String date;
  int read;
  String registrationRecordId;
  String useName;
  AttachmentModel attachment;

  factory NoteResponse.fromJson(Map<String, dynamic> json) => NoteResponse(
        id: json["id"].toString(),
        title: json['title'],
        note: Bidi.stripHtmlIfNeeded(json['note']),
        name: json["name"] ?? json['username'],
        type: json["type"],
        date: json["date"],
        read: json['read'],
        registrationRecordId: json['registration_record_id'].toString(),
        useName: json['username'],
        attachment: json.containsKey("attachment") && json["attachment"] != null
          ? AttachmentModel.fromJson(json["attachment"])
          : AttachmentModel.zero(),
      );

  factory NoteResponse.zero() => NoteResponse(
        id: '',
        title: '',
        note: '',
        name: '',
        type: '',
        date: '',
        read: 0,
        registrationRecordId: '',
        useName: '',
        attachment: AttachmentModel.zero(),
      );

  static List<NoteResponse> fromJsonList(
    Map<String, dynamic> json,
    String key,
  ) {
    List<NoteResponse> notes = [];
    if (json[key] == null) {
      return [];
    }
    try {
      json[key].forEach(
        (element) => notes.add(
          NoteResponse.fromJson(element),
        ),
      );
    } catch (e) {
      print(e.toString());
    }

    return notes;
  }
}

// class AttachmentModel {
//   int id;
//   String name;
//   String path;
//   String size;
//   String mimetype;
//   AttachmentModel(
//       {required this.id,
//       required this.name,
//       required this.path,
//       required this.size,
//       required this.mimetype});

//   factory AttachmentModel.zero() => AttachmentModel(id: 0,name: '',path: '',size: '',mimetype: '');

//   factory AttachmentModel.fromJson(Map<String, dynamic> json) =>
//       AttachmentModel(
//           id: json["id"],
//           name: json["name"],
//           path: json["path"],
//           size: json["size"].toString(),
//           mimetype: json["mimetype"]);

//   static List<AttachmentModel> fromJsonList(Map<String, dynamic> json) {
//     List<AttachmentModel> attachments = [];
//     json["attachment"].forEach(
//       (element) => attachments.add(
//         AttachmentModel.fromJson(element),
//       ),
//     );
//     return attachments;
//   }
// }
