import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/text.dart';
import '../../business_logic/note_controller.dart';

class NoteDetailsScreen extends StatefulWidget {

  const NoteDetailsScreen({super.key});

  @override
  State<NoteDetailsScreen> createState() => _NoteDetailsScreenState();
}

class _NoteDetailsScreenState extends State<NoteDetailsScreen> {
  final NoteController noteController = Get.find<NoteController>();

  String id = '';

  @override
  Widget build(BuildContext context) {
    if (Get.arguments != null) {
      id = Get.arguments;
      noteController.getSingleNote(id);
    } else {
      id = '';
    }
    return Scaffold(
        appBar: AppBarWidget(title: 'Notes'.tr),
        body: Obx(() {
          return noteController.singleNoteState.loading
              ? const Center(
                  child: CircularProgressIndicatorWidget(),
                )
              : Padding(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 20, vertical: 10),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        children: [
                          TextTitle(
                            noteController
                                .getNoteResponseFromStateById(id)
                                .name,
                            textColor: AppColors.secondaryColor,
                          ).expanded(6),
                          NormalText(
                                  noteController
                                      .getNoteResponseFromStateById(id)
                                      .date
                                      .tr,
                                  textColor: AppColors.secondaryColor)
                              .expanded(2),
                        ],
                      ),
                      TextTitle(
                        noteController.getNoteResponseFromStateById(id).type.tr,
                        textColor: Colors.black45,
                      ),
                      NormalText(
                        noteController.getNoteResponseFromStateById(id).note.tr,
                        textColor: Colors.black,
                      ).padding(
                        padding: const EdgeInsets.symmetric(vertical: 10),
                      )
                    ],
                  ),
                );
        }));
  }
}
